/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.Serializable;
import java.util.ArrayList;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonProperty;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Account;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientInfo;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAccount;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IdToken;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;

class AccountCacheEntity
implements Serializable {
    static final String MSSTS_ACCOUNT_TYPE = "MSSTS";
    static final String ADFS_ACCOUNT_TYPE = "ADFS";
    @JsonProperty(value="home_account_id")
    protected String homeAccountId;
    @JsonProperty(value="environment")
    protected String environment;
    @JsonProperty(value="realm")
    protected String realm;
    @JsonProperty(value="local_account_id")
    protected String localAccountId;
    @JsonProperty(value="username")
    protected String username;
    @JsonProperty(value="name")
    protected String name;
    @JsonProperty(value="client_info")
    protected String clientInfoStr;
    @JsonProperty(value="user_assertion_hash")
    protected String userAssertionHash;
    @JsonProperty(value="authority_type")
    protected String authorityType;

    AccountCacheEntity() {
    }

    ClientInfo clientInfo() {
        return ClientInfo.createFromJson(this.clientInfoStr);
    }

    String getKey() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.homeAccountId);
        arrayList.add(this.environment);
        arrayList.add(StringHelper.isBlank(this.realm) ? "" : this.realm);
        return String.join((CharSequence)"-", arrayList).toLowerCase();
    }

    static AccountCacheEntity create(String string, Authority authority, IdToken idToken, String string2) {
        AccountCacheEntity accountCacheEntity = new AccountCacheEntity();
        accountCacheEntity.authorityType(MSSTS_ACCOUNT_TYPE);
        accountCacheEntity.clientInfoStr = string;
        accountCacheEntity.homeAccountId(string2 != null ? accountCacheEntity.clientInfo().toAccountIdentifier() + "-" + string2 : accountCacheEntity.clientInfo().toAccountIdentifier());
        accountCacheEntity.environment(authority.host());
        accountCacheEntity.realm(authority.tenant());
        if (idToken != null) {
            String string3 = !StringHelper.isBlank(idToken.objectIdentifier) ? idToken.objectIdentifier : idToken.subject;
            accountCacheEntity.localAccountId(string3);
            accountCacheEntity.username(idToken.preferredUsername);
            accountCacheEntity.name(idToken.name);
        }
        return accountCacheEntity;
    }

    static AccountCacheEntity createADFSAccount(Authority authority, IdToken idToken) {
        AccountCacheEntity accountCacheEntity = new AccountCacheEntity();
        accountCacheEntity.authorityType(ADFS_ACCOUNT_TYPE);
        accountCacheEntity.homeAccountId(idToken.subject);
        accountCacheEntity.environment(authority.host());
        accountCacheEntity.username(idToken.upn);
        accountCacheEntity.name(idToken.uniqueName);
        return accountCacheEntity;
    }

    static AccountCacheEntity create(String string, Authority authority, IdToken idToken) {
        return AccountCacheEntity.create(string, authority, idToken, null);
    }

    IAccount toAccount() {
        return new Account(this.homeAccountId, this.environment, this.username, null);
    }

    public String homeAccountId() {
        return this.homeAccountId;
    }

    public String environment() {
        return this.environment;
    }

    public String realm() {
        return this.realm;
    }

    public String localAccountId() {
        return this.localAccountId;
    }

    public String username() {
        return this.username;
    }

    public String name() {
        return this.name;
    }

    public String clientInfoStr() {
        return this.clientInfoStr;
    }

    public String userAssertionHash() {
        return this.userAssertionHash;
    }

    public String authorityType() {
        return this.authorityType;
    }

    public AccountCacheEntity homeAccountId(String string) {
        this.homeAccountId = string;
        return this;
    }

    public AccountCacheEntity environment(String string) {
        this.environment = string;
        return this;
    }

    public AccountCacheEntity realm(String string) {
        this.realm = string;
        return this;
    }

    public AccountCacheEntity localAccountId(String string) {
        this.localAccountId = string;
        return this;
    }

    public AccountCacheEntity username(String string) {
        this.username = string;
        return this;
    }

    public AccountCacheEntity name(String string) {
        this.name = string;
        return this;
    }

    public AccountCacheEntity clientInfoStr(String string) {
        this.clientInfoStr = string;
        return this;
    }

    public AccountCacheEntity userAssertionHash(String string) {
        this.userAssertionHash = string;
        return this;
    }

    public AccountCacheEntity authorityType(String string) {
        this.authorityType = string;
        return this;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AccountCacheEntity)) {
            return false;
        }
        AccountCacheEntity accountCacheEntity = (AccountCacheEntity)object;
        if (!accountCacheEntity.canEqual(this)) {
            return false;
        }
        String string = this.homeAccountId();
        String string2 = accountCacheEntity.homeAccountId();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        String string3 = this.environment();
        String string4 = accountCacheEntity.environment();
        if (string3 == null ? string4 != null : !string3.equals(string4)) {
            return false;
        }
        String string5 = this.realm();
        String string6 = accountCacheEntity.realm();
        if (string5 == null ? string6 != null : !string5.equals(string6)) {
            return false;
        }
        String string7 = this.localAccountId();
        String string8 = accountCacheEntity.localAccountId();
        if (string7 == null ? string8 != null : !string7.equals(string8)) {
            return false;
        }
        String string9 = this.username();
        String string10 = accountCacheEntity.username();
        if (string9 == null ? string10 != null : !string9.equals(string10)) {
            return false;
        }
        String string11 = this.name();
        String string12 = accountCacheEntity.name();
        if (string11 == null ? string12 != null : !string11.equals(string12)) {
            return false;
        }
        String string13 = this.clientInfoStr();
        String string14 = accountCacheEntity.clientInfoStr();
        if (string13 == null ? string14 != null : !string13.equals(string14)) {
            return false;
        }
        String string15 = this.userAssertionHash();
        String string16 = accountCacheEntity.userAssertionHash();
        if (string15 == null ? string16 != null : !string15.equals(string16)) {
            return false;
        }
        String string17 = this.authorityType();
        String string18 = accountCacheEntity.authorityType();
        return !(string17 == null ? string18 != null : !string17.equals(string18));
    }

    protected boolean canEqual(Object object) {
        return object instanceof AccountCacheEntity;
    }

    public int hashCode() {
        int n2 = 59;
        int n3 = 1;
        String string = this.homeAccountId();
        n3 = n3 * 59 + (string == null ? 43 : string.hashCode());
        String string2 = this.environment();
        n3 = n3 * 59 + (string2 == null ? 43 : string2.hashCode());
        String string3 = this.realm();
        n3 = n3 * 59 + (string3 == null ? 43 : string3.hashCode());
        String string4 = this.localAccountId();
        n3 = n3 * 59 + (string4 == null ? 43 : string4.hashCode());
        String string5 = this.username();
        n3 = n3 * 59 + (string5 == null ? 43 : string5.hashCode());
        String string6 = this.name();
        n3 = n3 * 59 + (string6 == null ? 43 : string6.hashCode());
        String string7 = this.clientInfoStr();
        n3 = n3 * 59 + (string7 == null ? 43 : string7.hashCode());
        String string8 = this.userAssertionHash();
        n3 = n3 * 59 + (string8 == null ? 43 : string8.hashCode());
        String string9 = this.authorityType();
        n3 = n3 * 59 + (string9 == null ? 43 : string9.hashCode());
        return n3;
    }
}

