/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.deser;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonFormat;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;

public class MonthDayDeserializer
extends JSR310DateTimeDeserializerBase<MonthDay> {
    private static final long serialVersionUID = 1L;
    public static final MonthDayDeserializer INSTANCE = new MonthDayDeserializer();

    public MonthDayDeserializer() {
        this((DateTimeFormatter)null);
    }

    public MonthDayDeserializer(DateTimeFormatter dateTimeFormatter) {
        super(MonthDay.class, dateTimeFormatter);
    }

    protected MonthDayDeserializer(MonthDayDeserializer monthDayDeserializer, Boolean bl2) {
        super(monthDayDeserializer, bl2);
    }

    protected MonthDayDeserializer(MonthDayDeserializer monthDayDeserializer, Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        super(monthDayDeserializer, bl2, dateTimeFormatter, shape);
    }

    @Override
    protected MonthDayDeserializer withLeniency(Boolean bl2) {
        return new MonthDayDeserializer(this, bl2);
    }

    protected MonthDayDeserializer withDateFormat(DateTimeFormatter dateTimeFormatter) {
        return new MonthDayDeserializer(this, (Boolean)this._isLenient, dateTimeFormatter, this._shape);
    }

    @Override
    public MonthDay deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            return this._fromString(jsonParser, deserializationContext, deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType()));
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                return null;
            }
            if ((jsonToken == JsonToken.VALUE_STRING || jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                MonthDay monthDay = this.deserialize(jsonParser, deserializationContext);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return monthDay;
            }
            if (jsonToken != JsonToken.VALUE_NUMBER_INT) {
                this._reportWrongToken(deserializationContext, JsonToken.VALUE_NUMBER_INT, "month");
            }
            int n2 = jsonParser.getIntValue();
            int n3 = jsonParser.nextIntValue(-1);
            if (n3 == -1) {
                if (!jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                    this._reportWrongToken(deserializationContext, JsonToken.VALUE_NUMBER_INT, "day");
                }
                n3 = jsonParser.getIntValue();
            }
            if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                throw deserializationContext.wrongTokenException(jsonParser, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
            }
            return MonthDay.of(n2, n3);
        }
        if (jsonParser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (MonthDay)jsonParser.getEmbeddedObject();
        }
        return (MonthDay)this._handleUnexpectedToken(deserializationContext, jsonParser, JsonToken.VALUE_STRING, JsonToken.START_ARRAY);
    }

    protected MonthDay _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return (MonthDay)this._fromEmptyString(jsonParser, deserializationContext, string2);
        }
        try {
            if (this._formatter == null) {
                return MonthDay.parse(string2);
            }
            return MonthDay.parse(string2, this._formatter);
        }
        catch (DateTimeException dateTimeException) {
            return (MonthDay)this._handleDateTimeException(deserializationContext, dateTimeException, string2);
        }
    }
}

