/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml;

import java.io.IOException;
import java.util.Collection;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonTypeInfo;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DatabindContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.MapperConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.NamedType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.impl.MinimalClassNameIdResolver;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.TypeFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.util.StaxUtil;

public class XmlTypeResolverBuilder
extends StdTypeResolverBuilder {
    public XmlTypeResolverBuilder() {
    }

    public XmlTypeResolverBuilder(JsonTypeInfo.Value value) {
        super(value);
    }

    @Override
    protected String _propName(String string, JsonTypeInfo.Id id) {
        if (string == null || string.isEmpty()) {
            string = StaxUtil.sanitizeXmlTypeName(id.getDefaultPropertyName());
        } else if (string.equals(id.getDefaultPropertyName())) {
            string = StaxUtil.sanitizeXmlTypeName(string);
        }
        return string;
    }

    @Override
    protected TypeIdResolver idResolver(MapperConfig<?> mapperConfig, JavaType javaType, PolymorphicTypeValidator polymorphicTypeValidator, Collection<NamedType> collection, boolean bl2, boolean bl3) {
        if (this._customIdResolver != null) {
            return this._customIdResolver;
        }
        switch (this._idType) {
            case CLASS: {
                return new XmlClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), this.subTypeValidator(mapperConfig));
            }
            case MINIMAL_CLASS: {
                return new XmlMinimalClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), this.subTypeValidator(mapperConfig));
            }
        }
        return super.idResolver(mapperConfig, javaType, polymorphicTypeValidator, collection, bl2, bl3);
    }

    protected static String encodeXmlClassName(String string) {
        int n2 = string.lastIndexOf(36);
        if (n2 >= 0) {
            StringBuilder stringBuilder = new StringBuilder(string);
            do {
                stringBuilder.replace(n2, n2 + 1, "..");
            } while ((n2 = string.lastIndexOf(36, n2 - 1)) >= 0);
            string = stringBuilder.toString();
        }
        return string;
    }

    protected static String decodeXmlClassName(String string) {
        int n2 = string.lastIndexOf("..");
        if (n2 >= 0) {
            StringBuilder stringBuilder = new StringBuilder(string);
            do {
                stringBuilder.replace(n2, n2 + 2, "$");
            } while ((n2 = string.lastIndexOf("..", n2 - 1)) >= 0);
            string = stringBuilder.toString();
        }
        return string;
    }

    protected static class XmlMinimalClassNameIdResolver
    extends MinimalClassNameIdResolver {
        private static final long serialVersionUID = 2L;

        public XmlMinimalClassNameIdResolver(JavaType javaType, TypeFactory typeFactory, PolymorphicTypeValidator polymorphicTypeValidator) {
            super(javaType, typeFactory, polymorphicTypeValidator);
        }

        @Override
        public String idFromValue(Object object) {
            return XmlTypeResolverBuilder.encodeXmlClassName(super.idFromValue(object));
        }

        @Override
        public JavaType typeFromId(DatabindContext databindContext, String string) throws IOException {
            return super.typeFromId(databindContext, XmlTypeResolverBuilder.decodeXmlClassName(string));
        }
    }

    protected static class XmlClassNameIdResolver
    extends ClassNameIdResolver {
        private static final long serialVersionUID = 2L;

        public XmlClassNameIdResolver(JavaType javaType, TypeFactory typeFactory, PolymorphicTypeValidator polymorphicTypeValidator) {
            super(javaType, typeFactory, polymorphicTypeValidator);
        }

        @Override
        public String idFromValue(Object object) {
            return XmlTypeResolverBuilder.encodeXmlClassName(super.idFromValue(object));
        }

        @Override
        public JavaType typeFromId(DatabindContext databindContext, String string) throws IOException {
            return super.typeFromId(databindContext, XmlTypeResolverBuilder.decodeXmlClassName(string));
        }
    }
}

