/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml;

import java.io.IOException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.Base64Variants;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.Version;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.type.TypeReference;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.AnnotationIntrospector;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.CoercionAction;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.MapperBuilder;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.type.LogicalType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.DefaultingXmlTypeResolverBuilder;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.JacksonXmlAnnotationIntrospector;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.PackageVersion;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.XmlFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.XmlNameProcessor;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.deser.XmlDeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.ser.XmlSerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.util.XmlRootNameLookup;

public class XmlMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;
    protected static final JacksonXmlModule DEFAULT_XML_MODULE = new JacksonXmlModule();
    protected static final DefaultXmlPrettyPrinter DEFAULT_XML_PRETTY_PRINTER = new DefaultXmlPrettyPrinter();
    protected final JacksonXmlModule _xmlModule;

    public XmlMapper() {
        this(new XmlFactory());
    }

    public XmlMapper(XMLInputFactory xMLInputFactory, XMLOutputFactory xMLOutputFactory) {
        this(new XmlFactory(xMLInputFactory, xMLOutputFactory));
    }

    public XmlMapper(XMLInputFactory xMLInputFactory) {
        this(new XmlFactory(xMLInputFactory));
    }

    public XmlMapper(XmlFactory xmlFactory) {
        this(xmlFactory, DEFAULT_XML_MODULE);
    }

    public XmlMapper(JacksonXmlModule jacksonXmlModule) {
        this(new XmlFactory(), jacksonXmlModule);
    }

    public XmlMapper(XmlFactory xmlFactory, JacksonXmlModule jacksonXmlModule) {
        super(xmlFactory, new XmlSerializerProvider(new XmlRootNameLookup()), new XmlDeserializationContext(BeanDeserializerFactory.instance));
        this._xmlModule = jacksonXmlModule;
        if (jacksonXmlModule != null) {
            this.registerModule(jacksonXmlModule);
        }
        this._serializationConfig = this._serializationConfig.withDefaultPrettyPrinter(DEFAULT_XML_PRETTY_PRINTER);
        this.enable(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT);
        this.setBase64Variant(Base64Variants.MIME);
        this.coercionConfigDefaults().setAcceptBlankAsEmpty(Boolean.TRUE).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsEmpty);
        this.coercionConfigFor(LogicalType.Integer).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull);
        this.coercionConfigFor(LogicalType.Float).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull);
        this.coercionConfigFor(LogicalType.Boolean).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull);
    }

    protected XmlMapper(XmlMapper xmlMapper) {
        super(xmlMapper);
        this._xmlModule = xmlMapper._xmlModule;
    }

    @Override
    public XmlMapper copy() {
        this._checkInvalidCopy(XmlMapper.class);
        return new XmlMapper(this);
    }

    public static Builder xmlBuilder() {
        return new Builder(new XmlMapper());
    }

    public static Builder builder() {
        return new Builder(new XmlMapper());
    }

    public static Builder builder(XmlFactory xmlFactory) {
        return new Builder(new XmlMapper(xmlFactory));
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    protected TypeResolverBuilder<?> _constructDefaultTypeResolverBuilder(ObjectMapper.DefaultTyping defaultTyping, PolymorphicTypeValidator polymorphicTypeValidator) {
        return new DefaultingXmlTypeResolverBuilder(defaultTyping, polymorphicTypeValidator);
    }

    @Deprecated
    protected void setXMLTextElementName(String string) {
        this.getFactory().setXMLTextElementName(string);
    }

    @Deprecated
    public XmlMapper setDefaultUseWrapper(boolean bl2) {
        AnnotationIntrospector annotationIntrospector = this.getDeserializationConfig().getAnnotationIntrospector();
        for (AnnotationIntrospector annotationIntrospector2 : annotationIntrospector.allIntrospectors()) {
            if (!(annotationIntrospector2 instanceof JacksonXmlAnnotationIntrospector)) continue;
            ((JacksonXmlAnnotationIntrospector)annotationIntrospector2).setDefaultUseWrapper(bl2);
        }
        return this;
    }

    public void setXmlNameProcessor(XmlNameProcessor xmlNameProcessor) {
        this.getFactory().setXmlNameProcessor(xmlNameProcessor);
    }

    @Override
    public XmlFactory getFactory() {
        return (XmlFactory)this._jsonFactory;
    }

    public ObjectMapper configure(ToXmlGenerator.Feature feature, boolean bl2) {
        ((XmlFactory)this._jsonFactory).configure(feature, bl2);
        return this;
    }

    public ObjectMapper configure(FromXmlParser.Feature feature, boolean bl2) {
        ((XmlFactory)this._jsonFactory).configure(feature, bl2);
        return this;
    }

    public ObjectMapper enable(ToXmlGenerator.Feature feature) {
        ((XmlFactory)this._jsonFactory).enable(feature);
        return this;
    }

    public ObjectMapper enable(FromXmlParser.Feature feature) {
        ((XmlFactory)this._jsonFactory).enable(feature);
        return this;
    }

    public ObjectMapper disable(ToXmlGenerator.Feature feature) {
        ((XmlFactory)this._jsonFactory).disable(feature);
        return this;
    }

    public ObjectMapper disable(FromXmlParser.Feature feature) {
        ((XmlFactory)this._jsonFactory).disable(feature);
        return this;
    }

    public FromXmlParser createParser(XMLStreamReader xMLStreamReader) throws IOException {
        return this.getFactory().createParser(xMLStreamReader);
    }

    public ToXmlGenerator createGenerator(XMLStreamWriter xMLStreamWriter) throws IOException {
        return this.getFactory().createGenerator(xMLStreamWriter);
    }

    public <T> T readValue(XMLStreamReader xMLStreamReader, Class<T> clazz) throws IOException {
        return this.readValue(xMLStreamReader, this._typeFactory.constructType(clazz));
    }

    public <T> T readValue(XMLStreamReader xMLStreamReader, TypeReference<T> typeReference) throws IOException {
        return this.readValue(xMLStreamReader, this._typeFactory.constructType(typeReference));
    }

    public <T> T readValue(XMLStreamReader xMLStreamReader, JavaType javaType) throws IOException {
        FromXmlParser fromXmlParser = this.createParser(xMLStreamReader);
        return super.readValue((JsonParser)fromXmlParser, javaType);
    }

    public void writeValue(XMLStreamWriter xMLStreamWriter, Object object) throws IOException {
        ToXmlGenerator toXmlGenerator = this.createGenerator(xMLStreamWriter);
        super.writeValue(toXmlGenerator, object);
    }

    public static class Builder
    extends MapperBuilder<XmlMapper, Builder> {
        public Builder(XmlMapper xmlMapper) {
            super(xmlMapper);
        }

        public Builder enable(FromXmlParser.Feature ... featureArray) {
            for (FromXmlParser.Feature feature : featureArray) {
                ((XmlMapper)this._mapper).enable(feature);
            }
            return this;
        }

        public Builder disable(FromXmlParser.Feature ... featureArray) {
            for (FromXmlParser.Feature feature : featureArray) {
                ((XmlMapper)this._mapper).disable(feature);
            }
            return this;
        }

        public Builder configure(FromXmlParser.Feature feature, boolean bl2) {
            if (bl2) {
                ((XmlMapper)this._mapper).enable(feature);
            } else {
                ((XmlMapper)this._mapper).disable(feature);
            }
            return this;
        }

        public Builder enable(ToXmlGenerator.Feature ... featureArray) {
            for (ToXmlGenerator.Feature feature : featureArray) {
                ((XmlMapper)this._mapper).enable(feature);
            }
            return this;
        }

        public Builder disable(ToXmlGenerator.Feature ... featureArray) {
            for (ToXmlGenerator.Feature feature : featureArray) {
                ((XmlMapper)this._mapper).disable(feature);
            }
            return this;
        }

        public Builder configure(ToXmlGenerator.Feature feature, boolean bl2) {
            if (bl2) {
                ((XmlMapper)this._mapper).enable(feature);
            } else {
                ((XmlMapper)this._mapper).disable(feature);
            }
            return this;
        }

        public Builder nameForTextElement(String string) {
            ((XmlMapper)this._mapper).setXMLTextElementName(string);
            return this;
        }

        public Builder defaultUseWrapper(boolean bl2) {
            ((XmlMapper)this._mapper).setDefaultUseWrapper(bl2);
            return this;
        }

        public Builder xmlNameProcessor(XmlNameProcessor xmlNameProcessor) {
            ((XmlMapper)this._mapper).setXmlNameProcessor(xmlNameProcessor);
            return this;
        }
    }
}

