/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml;

import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.TSFBuilder;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.XmlFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.XmlNameProcessor;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.XmlNameProcessors;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.util.StaxUtil;

public class XmlFactoryBuilder
extends TSFBuilder<XmlFactory, XmlFactoryBuilder> {
    protected int _formatParserFeatures;
    protected int _formatGeneratorFeatures;
    protected XMLInputFactory _xmlInputFactory;
    protected XMLOutputFactory _xmlOutputFactory;
    protected String _nameForTextElement;
    protected ClassLoader _classLoaderForStax;
    protected XmlNameProcessor _nameProcessor;

    protected XmlFactoryBuilder() {
        this._formatParserFeatures = XmlFactory.DEFAULT_XML_PARSER_FEATURE_FLAGS;
        this._formatGeneratorFeatures = XmlFactory.DEFAULT_XML_GENERATOR_FEATURE_FLAGS;
        this._classLoaderForStax = null;
        this._nameProcessor = XmlNameProcessors.newPassthroughProcessor();
    }

    public XmlFactoryBuilder(XmlFactory xmlFactory) {
        super(xmlFactory);
        this._formatParserFeatures = xmlFactory._xmlParserFeatures;
        this._formatGeneratorFeatures = xmlFactory._xmlGeneratorFeatures;
        this._xmlInputFactory = xmlFactory._xmlInputFactory;
        this._xmlOutputFactory = xmlFactory._xmlOutputFactory;
        this._nameForTextElement = xmlFactory._cfgNameForTextElement;
        this._nameProcessor = xmlFactory._nameProcessor;
        this._classLoaderForStax = null;
    }

    public int formatParserFeaturesMask() {
        return this._formatParserFeatures;
    }

    public int formatGeneratorFeaturesMask() {
        return this._formatGeneratorFeatures;
    }

    public String nameForTextElement() {
        return this._nameForTextElement;
    }

    public XMLInputFactory xmlInputFactory() {
        if (this._xmlInputFactory == null) {
            return this.defaultInputFactory();
        }
        return this._xmlInputFactory;
    }

    protected XMLInputFactory defaultInputFactory() {
        XMLInputFactory xMLInputFactory = StaxUtil.defaultInputFactory(this._classLoaderForStax);
        xMLInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xMLInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return xMLInputFactory;
    }

    public XMLOutputFactory xmlOutputFactory() {
        if (this._xmlOutputFactory == null) {
            return this.defaultOutputFactory();
        }
        return this._xmlOutputFactory;
    }

    protected XMLOutputFactory defaultOutputFactory() {
        XMLOutputFactory xMLOutputFactory = StaxUtil.defaultOutputFactory(this._classLoaderForStax);
        xMLOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        return xMLOutputFactory;
    }

    protected ClassLoader staxClassLoader() {
        return this._classLoaderForStax == null ? this.getClass().getClassLoader() : this._classLoaderForStax;
    }

    public XmlNameProcessor xmlNameProcessor() {
        return this._nameProcessor;
    }

    public XmlFactoryBuilder enable(FromXmlParser.Feature feature) {
        this._formatParserFeatures |= feature.getMask();
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder enable(FromXmlParser.Feature feature, FromXmlParser.Feature ... featureArray) {
        this._formatParserFeatures |= feature.getMask();
        for (FromXmlParser.Feature feature2 : featureArray) {
            this._formatParserFeatures |= feature2.getMask();
        }
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder disable(FromXmlParser.Feature feature) {
        this._formatParserFeatures &= ~feature.getMask();
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder disable(FromXmlParser.Feature feature, FromXmlParser.Feature ... featureArray) {
        this._formatParserFeatures &= ~feature.getMask();
        for (FromXmlParser.Feature feature2 : featureArray) {
            this._formatParserFeatures &= ~feature2.getMask();
        }
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder configure(FromXmlParser.Feature feature, boolean bl2) {
        return bl2 ? this.enable(feature) : this.disable(feature);
    }

    public XmlFactoryBuilder enable(ToXmlGenerator.Feature feature) {
        this._formatGeneratorFeatures |= feature.getMask();
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder enable(ToXmlGenerator.Feature feature, ToXmlGenerator.Feature ... featureArray) {
        this._formatGeneratorFeatures |= feature.getMask();
        for (ToXmlGenerator.Feature feature2 : featureArray) {
            this._formatGeneratorFeatures |= feature2.getMask();
        }
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder disable(ToXmlGenerator.Feature feature) {
        this._formatGeneratorFeatures &= ~feature.getMask();
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder disable(ToXmlGenerator.Feature feature, ToXmlGenerator.Feature ... featureArray) {
        this._formatGeneratorFeatures &= ~feature.getMask();
        for (ToXmlGenerator.Feature feature2 : featureArray) {
            this._formatGeneratorFeatures &= ~feature2.getMask();
        }
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder configure(ToXmlGenerator.Feature feature, boolean bl2) {
        return bl2 ? this.enable(feature) : this.disable(feature);
    }

    public XmlFactoryBuilder nameForTextElement(String string) {
        this._nameForTextElement = string;
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder xmlInputFactory(XMLInputFactory xMLInputFactory) {
        this._xmlInputFactory = xMLInputFactory;
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder xmlOutputFactory(XMLOutputFactory xMLOutputFactory) {
        this._xmlOutputFactory = xMLOutputFactory;
        return (XmlFactoryBuilder)this._this();
    }

    @Deprecated
    public XmlFactoryBuilder inputFactory(XMLInputFactory xMLInputFactory) {
        return this.xmlInputFactory(xMLInputFactory);
    }

    @Deprecated
    public XmlFactoryBuilder outputFactory(XMLOutputFactory xMLOutputFactory) {
        return this.xmlOutputFactory(xMLOutputFactory);
    }

    public XmlFactoryBuilder staxClassLoader(ClassLoader classLoader) {
        this._classLoaderForStax = classLoader;
        return (XmlFactoryBuilder)this._this();
    }

    public XmlFactoryBuilder xmlNameProcessor(XmlNameProcessor xmlNameProcessor) {
        this._nameProcessor = xmlNameProcessor;
        return (XmlFactoryBuilder)this._this();
    }

    @Override
    public XmlFactory build() {
        return new XmlFactory(this);
    }
}

