/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.Base64Variant;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JacksonException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonLocation;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonStreamContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.ObjectCodec;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.StreamReadCapability;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.Version;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.base.ParserMinimalBase;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.util.JacksonFeatureSet;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.PackageVersion;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.BinaryNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.NodeCursor;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.NumericNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.POJONode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.TextNode;

public class TreeTraversingParser
extends ParserMinimalBase {
    protected ObjectCodec _objectCodec;
    protected NodeCursor _nodeCursor;
    protected boolean _closed;

    public TreeTraversingParser(JsonNode jsonNode) {
        this(jsonNode, null);
    }

    public TreeTraversingParser(JsonNode jsonNode, ObjectCodec objectCodec) {
        super(0);
        this._objectCodec = objectCodec;
        this._nodeCursor = new NodeCursor.RootCursor(jsonNode, null);
    }

    @Override
    public void setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public JacksonFeatureSet<StreamReadCapability> getReadCapabilities() {
        return DEFAULT_READ_CAPABILITIES;
    }

    @Override
    public void close() throws IOException {
        if (!this._closed) {
            this._closed = true;
            this._nodeCursor = null;
            this._currToken = null;
        }
    }

    @Override
    public JsonToken nextToken() throws IOException {
        this._currToken = this._nodeCursor.nextToken();
        if (this._currToken == null) {
            this._closed = true;
            return null;
        }
        switch (this._currToken) {
            case START_OBJECT: {
                this._nodeCursor = this._nodeCursor.startObject();
                break;
            }
            case START_ARRAY: {
                this._nodeCursor = this._nodeCursor.startArray();
                break;
            }
            case END_OBJECT: 
            case END_ARRAY: {
                this._nodeCursor = this._nodeCursor.getParent();
            }
        }
        return this._currToken;
    }

    @Override
    public JsonParser skipChildren() throws IOException {
        if (this._currToken == JsonToken.START_OBJECT) {
            this._nodeCursor = this._nodeCursor.getParent();
            this._currToken = JsonToken.END_OBJECT;
        } else if (this._currToken == JsonToken.START_ARRAY) {
            this._nodeCursor = this._nodeCursor.getParent();
            this._currToken = JsonToken.END_ARRAY;
        }
        return this;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public String currentName() {
        NodeCursor nodeCursor = this._nodeCursor;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            nodeCursor = nodeCursor.getParent();
        }
        return nodeCursor == null ? null : nodeCursor.getCurrentName();
    }

    @Override
    @Deprecated
    public String getCurrentName() {
        return this.currentName();
    }

    @Override
    public void overrideCurrentName(String string) {
        NodeCursor nodeCursor = this._nodeCursor;
        if (this._currToken == JsonToken.START_OBJECT || this._currToken == JsonToken.START_ARRAY) {
            nodeCursor = nodeCursor.getParent();
        }
        if (nodeCursor != null) {
            nodeCursor.overrideCurrentName(string);
        }
    }

    @Override
    public JsonStreamContext getParsingContext() {
        return this._nodeCursor;
    }

    @Override
    public JsonLocation currentLocation() {
        return JsonLocation.NA;
    }

    @Override
    public JsonLocation currentTokenLocation() {
        return JsonLocation.NA;
    }

    @Override
    @Deprecated
    public JsonLocation getTokenLocation() {
        return this.currentTokenLocation();
    }

    @Override
    @Deprecated
    public JsonLocation getCurrentLocation() {
        return this.currentLocation();
    }

    @Override
    public String getText() {
        if (this._currToken == null) {
            return null;
        }
        switch (this._currToken) {
            case FIELD_NAME: {
                return this._nodeCursor.getCurrentName();
            }
            case VALUE_STRING: {
                return this.currentNode().textValue();
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return String.valueOf(this.currentNode().numberValue());
            }
            case VALUE_EMBEDDED_OBJECT: {
                JsonNode jsonNode = this.currentNode();
                if (jsonNode == null || !jsonNode.isBinary()) break;
                return jsonNode.asText();
            }
        }
        return this._currToken.asString();
    }

    @Override
    public char[] getTextCharacters() throws IOException {
        return this.getText().toCharArray();
    }

    @Override
    public int getTextLength() throws IOException {
        return this.getText().length();
    }

    @Override
    public int getTextOffset() throws IOException {
        return 0;
    }

    @Override
    public boolean hasTextCharacters() {
        return false;
    }

    @Override
    public JsonParser.NumberType getNumberType() throws IOException {
        JsonNode jsonNode = this.currentNumericNode();
        return jsonNode == null ? null : jsonNode.numberType();
    }

    @Override
    public JsonParser.NumberTypeFP getNumberTypeFP() throws IOException {
        JsonParser.NumberType numberType = this.getNumberType();
        if (numberType == JsonParser.NumberType.BIG_DECIMAL) {
            return JsonParser.NumberTypeFP.BIG_DECIMAL;
        }
        if (numberType == JsonParser.NumberType.DOUBLE) {
            return JsonParser.NumberTypeFP.DOUBLE64;
        }
        if (numberType == JsonParser.NumberType.FLOAT) {
            return JsonParser.NumberTypeFP.FLOAT32;
        }
        return JsonParser.NumberTypeFP.UNKNOWN;
    }

    @Override
    public BigInteger getBigIntegerValue() throws IOException {
        return this.currentNumericNode().bigIntegerValue();
    }

    @Override
    public BigDecimal getDecimalValue() throws IOException {
        return this.currentNumericNode().decimalValue();
    }

    @Override
    public double getDoubleValue() throws IOException {
        return this.currentNumericNode().doubleValue();
    }

    @Override
    public float getFloatValue() throws IOException {
        return (float)this.currentNumericNode().doubleValue();
    }

    @Override
    public int getIntValue() throws IOException {
        NumericNode numericNode = (NumericNode)this.currentNumericNode();
        if (!numericNode.canConvertToInt()) {
            this.reportOverflowInt();
        }
        return numericNode.intValue();
    }

    @Override
    public long getLongValue() throws IOException {
        NumericNode numericNode = (NumericNode)this.currentNumericNode();
        if (!numericNode.canConvertToLong()) {
            this.reportOverflowLong();
        }
        return numericNode.longValue();
    }

    @Override
    public Number getNumberValue() throws IOException {
        return this.currentNumericNode().numberValue();
    }

    @Override
    public Object getEmbeddedObject() {
        JsonNode jsonNode;
        if (!this._closed && (jsonNode = this.currentNode()) != null) {
            if (jsonNode.isPojo()) {
                return ((POJONode)jsonNode).getPojo();
            }
            if (jsonNode.isBinary()) {
                return ((BinaryNode)jsonNode).binaryValue();
            }
        }
        return null;
    }

    @Override
    public boolean isNaN() {
        JsonNode jsonNode;
        if (!this._closed && (jsonNode = this.currentNode()) instanceof NumericNode) {
            return ((NumericNode)jsonNode).isNaN();
        }
        return false;
    }

    @Override
    public byte[] getBinaryValue(Base64Variant base64Variant) throws IOException {
        JsonNode jsonNode = this.currentNode();
        if (jsonNode != null) {
            if (jsonNode instanceof TextNode) {
                return ((TextNode)jsonNode).getBinaryValue(base64Variant);
            }
            return jsonNode.binaryValue();
        }
        return null;
    }

    @Override
    public int readBinaryValue(Base64Variant base64Variant, OutputStream outputStream) throws IOException {
        byte[] byArray = this.getBinaryValue(base64Variant);
        if (byArray != null) {
            outputStream.write(byArray, 0, byArray.length);
            return byArray.length;
        }
        return 0;
    }

    protected JsonNode currentNode() {
        if (this._closed || this._nodeCursor == null) {
            return null;
        }
        return this._nodeCursor.currentNode();
    }

    protected JsonNode currentNumericNode() throws JacksonException {
        JsonNode jsonNode = this.currentNode();
        if (jsonNode == null || !jsonNode.isNumber()) {
            JsonToken jsonToken = jsonNode == null ? null : jsonNode.asToken();
            throw this._constructError("Current token (" + (Object)((Object)jsonToken) + ") not numeric, cannot use numeric value accessors");
        }
        return jsonNode;
    }

    @Override
    protected void _handleEOF() {
        this._throwInternal();
    }
}

