/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonSerializable;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectReader;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectWriter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.json.JsonMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ArrayNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.BaseJsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ObjectNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.POJONode;

final class InternalNodeMapper {
    private static final JsonMapper JSON_MAPPER = new JsonMapper();
    private static final ObjectWriter STD_WRITER = JSON_MAPPER.writer();
    private static final ObjectWriter PRETTY_WRITER = JSON_MAPPER.writer().withDefaultPrettyPrinter();
    private static final ObjectReader NODE_READER = JSON_MAPPER.readerFor(JsonNode.class);

    InternalNodeMapper() {
    }

    public static String nodeToString(BaseJsonNode baseJsonNode) {
        try {
            return STD_WRITER.writeValueAsString(InternalNodeMapper._wrapper(baseJsonNode));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static String nodeToPrettyString(BaseJsonNode baseJsonNode) {
        try {
            return PRETTY_WRITER.writeValueAsString(InternalNodeMapper._wrapper(baseJsonNode));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static byte[] valueToBytes(Object object) throws IOException {
        return JSON_MAPPER.writeValueAsBytes(object);
    }

    public static JsonNode bytesToNode(byte[] byArray) throws IOException {
        return (JsonNode)NODE_READER.readValue(byArray);
    }

    private static JsonSerializable _wrapper(BaseJsonNode baseJsonNode) {
        return new WrapperForSerializer(baseJsonNode);
    }

    static final class IteratorStack {
        private Iterator<?>[] _stack;
        private int _top;
        private int _end;

        public void push(Iterator<?> iterator) {
            if (this._top < this._end) {
                this._stack[this._top++] = iterator;
                return;
            }
            if (this._stack == null) {
                this._end = 10;
                this._stack = new Iterator[this._end];
            } else {
                this._end += Math.min(4000, Math.max(20, this._end >> 1));
                this._stack = Arrays.copyOf(this._stack, this._end);
            }
            this._stack[this._top++] = iterator;
        }

        public Iterator<?> popOrNull() {
            if (this._top == 0) {
                return null;
            }
            return this._stack[--this._top];
        }
    }

    protected static class WrapperForSerializer
    extends JsonSerializable.Base {
        protected final BaseJsonNode _root;
        protected SerializerProvider _context;

        public WrapperForSerializer(BaseJsonNode baseJsonNode) {
            this._root = baseJsonNode;
        }

        @Override
        public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            this._context = serializerProvider;
            this._serializeNonRecursive(jsonGenerator, this._root);
        }

        @Override
        public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.serialize(jsonGenerator, serializerProvider);
        }

        protected void _serializeNonRecursive(JsonGenerator jsonGenerator, JsonNode jsonNode) throws IOException {
            if (jsonNode instanceof ObjectNode) {
                jsonGenerator.writeStartObject(this, jsonNode.size());
                this._serializeNonRecursive(jsonGenerator, new IteratorStack(), jsonNode.fields());
            } else if (jsonNode instanceof ArrayNode) {
                jsonGenerator.writeStartArray(this, jsonNode.size());
                this._serializeNonRecursive(jsonGenerator, new IteratorStack(), jsonNode.elements());
            } else {
                jsonNode.serialize(jsonGenerator, this._context);
            }
        }

        protected void _serializeNonRecursive(JsonGenerator jsonGenerator, IteratorStack iteratorStack, Iterator<?> iterator) throws IOException {
            Iterator<Object> iterator2 = iterator;
            while (true) {
                if (iterator2.hasNext()) {
                    JsonNode jsonNode;
                    Object obj = iterator2.next();
                    if (obj instanceof Map.Entry) {
                        Map.Entry entry = (Map.Entry)obj;
                        jsonGenerator.writeFieldName((String)entry.getKey());
                        jsonNode = (JsonNode)entry.getValue();
                    } else {
                        jsonNode = (JsonNode)obj;
                    }
                    if (jsonNode instanceof ObjectNode) {
                        iteratorStack.push(iterator2);
                        iterator2 = jsonNode.fields();
                        jsonGenerator.writeStartObject(jsonNode, jsonNode.size());
                        continue;
                    }
                    if (jsonNode instanceof ArrayNode) {
                        iteratorStack.push(iterator2);
                        iterator2 = jsonNode.elements();
                        jsonGenerator.writeStartArray(jsonNode, jsonNode.size());
                        continue;
                    }
                    if (jsonNode instanceof POJONode) {
                        try {
                            jsonNode.serialize(jsonGenerator, this._context);
                        }
                        catch (IOException | RuntimeException exception) {
                            jsonGenerator.writeString(String.format("[ERROR: (%s) %s]", exception.getClass().getName(), exception.getMessage()));
                        }
                        continue;
                    }
                    jsonNode.serialize(jsonGenerator, this._context);
                    continue;
                }
                if (jsonGenerator.getOutputContext().inArray()) {
                    jsonGenerator.writeEndArray();
                } else {
                    jsonGenerator.writeEndObject();
                }
                if ((iterator2 = iteratorStack.popOrNull()) == null) break;
            }
        }
    }
}

