/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonPointer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.type.WritableTypeId;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.BaseJsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ContainerNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.JsonNodeType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.MissingNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ObjectNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.RawValue;

public class ArrayNode
extends ContainerNode<ArrayNode>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<JsonNode> _children;

    public ArrayNode(JsonNodeFactory jsonNodeFactory) {
        super(jsonNodeFactory);
        this._children = new ArrayList<JsonNode>();
    }

    public ArrayNode(JsonNodeFactory jsonNodeFactory, int n2) {
        super(jsonNodeFactory);
        this._children = new ArrayList<JsonNode>(n2);
    }

    public ArrayNode(JsonNodeFactory jsonNodeFactory, List<JsonNode> list) {
        super(jsonNodeFactory);
        this._children = Objects.requireNonNull(list, "Must not pass `null` for 'children' argument");
    }

    @Override
    protected JsonNode _at(JsonPointer jsonPointer) {
        return this.get(jsonPointer.getMatchingIndex());
    }

    public ArrayNode deepCopy() {
        ArrayNode arrayNode = new ArrayNode(this._nodeFactory);
        for (JsonNode jsonNode : this._children) {
            arrayNode._children.add((JsonNode)jsonNode.deepCopy());
        }
        return arrayNode;
    }

    @Deprecated
    public ObjectNode with(String string) {
        JsonPointer jsonPointer = this._jsonPointerIfValid(string);
        if (jsonPointer != null) {
            return this.withObject(jsonPointer);
        }
        return (ObjectNode)super.with(string);
    }

    public ArrayNode withArray(String string) {
        JsonPointer jsonPointer = this._jsonPointerIfValid(string);
        if (jsonPointer != null) {
            return this.withArray(jsonPointer);
        }
        return (ArrayNode)super.withArray(string);
    }

    @Override
    protected ObjectNode _withObject(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode.OverwriteMode overwriteMode, boolean bl2) {
        if (jsonPointer2.matches()) {
            return null;
        }
        JsonNode jsonNode = this._at(jsonPointer2);
        if (jsonNode != null && jsonNode instanceof BaseJsonNode) {
            ObjectNode objectNode = ((BaseJsonNode)jsonNode)._withObject(jsonPointer, jsonPointer2.tail(), overwriteMode, bl2);
            if (objectNode != null) {
                return objectNode;
            }
            this._withXxxVerifyReplace(jsonPointer, jsonPointer2, overwriteMode, bl2, jsonNode);
        }
        return this._withObjectAddTailElement(jsonPointer2, bl2);
    }

    @Override
    protected ArrayNode _withArray(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode.OverwriteMode overwriteMode, boolean bl2) {
        if (jsonPointer2.matches()) {
            return this;
        }
        JsonNode jsonNode = this._at(jsonPointer2);
        if (jsonNode != null && jsonNode instanceof BaseJsonNode) {
            ArrayNode arrayNode = ((BaseJsonNode)jsonNode)._withArray(jsonPointer, jsonPointer2.tail(), overwriteMode, bl2);
            if (arrayNode != null) {
                return arrayNode;
            }
            this._withXxxVerifyReplace(jsonPointer, jsonPointer2, overwriteMode, bl2, jsonNode);
        }
        return this._withArrayAddTailElement(jsonPointer2, bl2);
    }

    protected ObjectNode _withObjectAddTailElement(JsonPointer jsonPointer, boolean bl2) {
        int n2 = jsonPointer.getMatchingIndex();
        if (n2 < 0) {
            return null;
        }
        if ((jsonPointer = jsonPointer.tail()).matches()) {
            ObjectNode objectNode = this.objectNode();
            this._withXxxSetArrayElement(n2, objectNode);
            return objectNode;
        }
        if (bl2 && jsonPointer.mayMatchElement()) {
            ArrayNode arrayNode = this.arrayNode();
            this._withXxxSetArrayElement(n2, arrayNode);
            return arrayNode._withObjectAddTailElement(jsonPointer, bl2);
        }
        ObjectNode objectNode = this.objectNode();
        this._withXxxSetArrayElement(n2, objectNode);
        return objectNode._withObjectAddTailProperty(jsonPointer, bl2);
    }

    protected ArrayNode _withArrayAddTailElement(JsonPointer jsonPointer, boolean bl2) {
        int n2 = jsonPointer.getMatchingIndex();
        if (n2 < 0) {
            return null;
        }
        if ((jsonPointer = jsonPointer.tail()).matches()) {
            ArrayNode arrayNode = this.arrayNode();
            this._withXxxSetArrayElement(n2, arrayNode);
            return arrayNode;
        }
        if (bl2 && jsonPointer.mayMatchElement()) {
            ArrayNode arrayNode = this.arrayNode();
            this._withXxxSetArrayElement(n2, arrayNode);
            return arrayNode._withArrayAddTailElement(jsonPointer, bl2);
        }
        ObjectNode objectNode = this.objectNode();
        this._withXxxSetArrayElement(n2, objectNode);
        return objectNode._withArrayAddTailProperty(jsonPointer, bl2);
    }

    protected void _withXxxSetArrayElement(int n2, JsonNode jsonNode) {
        if (n2 >= this.size()) {
            int n3 = this._nodeFactory.getMaxElementIndexForInsert();
            if (n2 > n3) {
                this._reportWrongNodeOperation("Too big Array index (%d; max %d) to use for insert with `JsonPointer`", n2, n3);
            }
            while (n2 >= this.size()) {
                this.addNull();
            }
        }
        this.set(n2, jsonNode);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider) {
        return this._children.isEmpty();
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.ARRAY;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.START_ARRAY;
    }

    @Override
    public int size() {
        return this._children.size();
    }

    @Override
    public boolean isEmpty() {
        return this._children.isEmpty();
    }

    @Override
    public Iterator<JsonNode> elements() {
        return this._children.iterator();
    }

    @Override
    public JsonNode get(int n2) {
        if (n2 >= 0 && n2 < this._children.size()) {
            return this._children.get(n2);
        }
        return null;
    }

    @Override
    public JsonNode get(String string) {
        return null;
    }

    @Override
    public JsonNode path(String string) {
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode path(int n2) {
        if (n2 >= 0 && n2 < this._children.size()) {
            return this._children.get(n2);
        }
        return MissingNode.getInstance();
    }

    @Override
    public JsonNode required(int n2) {
        if (n2 >= 0 && n2 < this._children.size()) {
            return this._children.get(n2);
        }
        return (JsonNode)this._reportRequiredViolation("No value at index #%d [0, %d) of `ArrayNode`", n2, this._children.size());
    }

    @Override
    public boolean equals(Comparator<JsonNode> comparator, JsonNode jsonNode) {
        if (!(jsonNode instanceof ArrayNode)) {
            return false;
        }
        ArrayNode arrayNode = (ArrayNode)jsonNode;
        int n2 = this._children.size();
        if (arrayNode.size() != n2) {
            return false;
        }
        List<JsonNode> list = this._children;
        List<JsonNode> list2 = arrayNode._children;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (list.get(i2).equals(comparator, list2.get(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        List<JsonNode> list = this._children;
        int n2 = list.size();
        jsonGenerator.writeStartArray(this, n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            JsonNode jsonNode = list.get(i2);
            jsonNode.serialize(jsonGenerator, serializerProvider);
        }
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeWithType(JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(this, JsonToken.START_ARRAY));
        for (JsonNode jsonNode : this._children) {
            ((BaseJsonNode)jsonNode).serialize(jsonGenerator, serializerProvider);
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    @Override
    public JsonNode findValue(String string) {
        for (JsonNode jsonNode : this._children) {
            JsonNode jsonNode2 = jsonNode.findValue(string);
            if (jsonNode2 == null) continue;
            return jsonNode2;
        }
        return null;
    }

    @Override
    public List<JsonNode> findValues(String string, List<JsonNode> list) {
        for (JsonNode jsonNode : this._children) {
            list = jsonNode.findValues(string, list);
        }
        return list;
    }

    @Override
    public List<String> findValuesAsText(String string, List<String> list) {
        for (JsonNode jsonNode : this._children) {
            list = jsonNode.findValuesAsText(string, list);
        }
        return list;
    }

    @Override
    public ObjectNode findParent(String string) {
        for (JsonNode jsonNode : this._children) {
            JsonNode jsonNode2 = jsonNode.findParent(string);
            if (jsonNode2 == null) continue;
            return (ObjectNode)jsonNode2;
        }
        return null;
    }

    @Override
    public List<JsonNode> findParents(String string, List<JsonNode> list) {
        for (JsonNode jsonNode : this._children) {
            list = jsonNode.findParents(string, list);
        }
        return list;
    }

    public JsonNode set(int n2, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        if (n2 < 0 || n2 >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + n2 + ", array size " + this.size());
        }
        return this._children.set(n2, jsonNode);
    }

    public ArrayNode add(JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._add(jsonNode);
        return this;
    }

    public ArrayNode addAll(ArrayNode arrayNode) {
        this._children.addAll(arrayNode._children);
        return this;
    }

    public ArrayNode addAll(Collection<? extends JsonNode> collection) {
        for (JsonNode jsonNode : collection) {
            this.add(jsonNode);
        }
        return this;
    }

    public ArrayNode insert(int n2, JsonNode jsonNode) {
        if (jsonNode == null) {
            jsonNode = this.nullNode();
        }
        this._insert(n2, jsonNode);
        return this;
    }

    public JsonNode remove(int n2) {
        if (n2 >= 0 && n2 < this._children.size()) {
            return this._children.remove(n2);
        }
        return null;
    }

    @Override
    public ArrayNode removeAll() {
        this._children.clear();
        return this;
    }

    public ArrayNode addArray() {
        ArrayNode arrayNode = this.arrayNode();
        this._add(arrayNode);
        return arrayNode;
    }

    public ObjectNode addObject() {
        ObjectNode objectNode = this.objectNode();
        this._add(objectNode);
        return objectNode;
    }

    public ArrayNode addPOJO(Object object) {
        return this._add(object == null ? this.nullNode() : this.pojoNode(object));
    }

    public ArrayNode addRawValue(RawValue rawValue) {
        return this._add(rawValue == null ? this.nullNode() : this.rawValueNode(rawValue));
    }

    public ArrayNode addNull() {
        return this._add(this.nullNode());
    }

    public ArrayNode add(short s2) {
        return this._add(this.numberNode(s2));
    }

    public ArrayNode add(Short s2) {
        return this._add(s2 == null ? this.nullNode() : this.numberNode((short)s2));
    }

    public ArrayNode add(int n2) {
        return this._add(this.numberNode(n2));
    }

    public ArrayNode add(Integer n2) {
        return this._add(n2 == null ? this.nullNode() : this.numberNode((int)n2));
    }

    public ArrayNode add(long l2) {
        return this._add(this.numberNode(l2));
    }

    public ArrayNode add(Long l2) {
        return this._add(l2 == null ? this.nullNode() : this.numberNode((long)l2));
    }

    public ArrayNode add(float f2) {
        return this._add(this.numberNode(f2));
    }

    public ArrayNode add(Float f2) {
        return this._add(f2 == null ? this.nullNode() : this.numberNode(f2.floatValue()));
    }

    public ArrayNode add(double d2) {
        return this._add(this.numberNode(d2));
    }

    public ArrayNode add(Double d2) {
        return this._add(d2 == null ? this.nullNode() : this.numberNode((double)d2));
    }

    public ArrayNode add(BigDecimal bigDecimal) {
        return this._add(bigDecimal == null ? this.nullNode() : this.numberNode(bigDecimal));
    }

    public ArrayNode add(BigInteger bigInteger) {
        return this._add(bigInteger == null ? this.nullNode() : this.numberNode(bigInteger));
    }

    public ArrayNode add(String string) {
        return this._add(string == null ? this.nullNode() : this.textNode(string));
    }

    public ArrayNode add(boolean bl2) {
        return this._add(this.booleanNode(bl2));
    }

    public ArrayNode add(Boolean bl2) {
        return this._add(bl2 == null ? this.nullNode() : this.booleanNode(bl2));
    }

    public ArrayNode add(byte[] byArray) {
        return this._add(byArray == null ? this.nullNode() : this.binaryNode(byArray));
    }

    public ArrayNode insertArray(int n2) {
        ArrayNode arrayNode = this.arrayNode();
        this._insert(n2, arrayNode);
        return arrayNode;
    }

    public ObjectNode insertObject(int n2) {
        ObjectNode objectNode = this.objectNode();
        this._insert(n2, objectNode);
        return objectNode;
    }

    public ArrayNode insertNull(int n2) {
        return this._insert(n2, this.nullNode());
    }

    public ArrayNode insertPOJO(int n2, Object object) {
        return this._insert(n2, object == null ? this.nullNode() : this.pojoNode(object));
    }

    public ArrayNode insertRawValue(int n2, RawValue rawValue) {
        return this._insert(n2, rawValue == null ? this.nullNode() : this.rawValueNode(rawValue));
    }

    public ArrayNode insert(int n2, short s2) {
        return this._insert(n2, this.numberNode(s2));
    }

    public ArrayNode insert(int n2, Short s2) {
        return this._insert(n2, s2 == null ? this.nullNode() : this.numberNode((short)s2));
    }

    public ArrayNode insert(int n2, int n3) {
        return this._insert(n2, this.numberNode(n3));
    }

    public ArrayNode insert(int n2, Integer n3) {
        return this._insert(n2, n3 == null ? this.nullNode() : this.numberNode((int)n3));
    }

    public ArrayNode insert(int n2, long l2) {
        return this._insert(n2, this.numberNode(l2));
    }

    public ArrayNode insert(int n2, Long l2) {
        return this._insert(n2, l2 == null ? this.nullNode() : this.numberNode((long)l2));
    }

    public ArrayNode insert(int n2, float f2) {
        return this._insert(n2, this.numberNode(f2));
    }

    public ArrayNode insert(int n2, Float f2) {
        return this._insert(n2, f2 == null ? this.nullNode() : this.numberNode(f2.floatValue()));
    }

    public ArrayNode insert(int n2, double d2) {
        return this._insert(n2, this.numberNode(d2));
    }

    public ArrayNode insert(int n2, Double d2) {
        return this._insert(n2, d2 == null ? this.nullNode() : this.numberNode((double)d2));
    }

    public ArrayNode insert(int n2, BigDecimal bigDecimal) {
        return this._insert(n2, bigDecimal == null ? this.nullNode() : this.numberNode(bigDecimal));
    }

    public ArrayNode insert(int n2, BigInteger bigInteger) {
        return this._insert(n2, bigInteger == null ? this.nullNode() : this.numberNode(bigInteger));
    }

    public ArrayNode insert(int n2, String string) {
        return this._insert(n2, string == null ? this.nullNode() : this.textNode(string));
    }

    public ArrayNode insert(int n2, boolean bl2) {
        return this._insert(n2, this.booleanNode(bl2));
    }

    public ArrayNode insert(int n2, Boolean bl2) {
        if (bl2 == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.booleanNode(bl2));
    }

    public ArrayNode insert(int n2, byte[] byArray) {
        if (byArray == null) {
            return this.insertNull(n2);
        }
        return this._insert(n2, this.binaryNode(byArray));
    }

    public ArrayNode setNull(int n2) {
        return this._set(n2, this.nullNode());
    }

    public ArrayNode setPOJO(int n2, Object object) {
        return this._set(n2, object == null ? this.nullNode() : this.pojoNode(object));
    }

    public ArrayNode setRawValue(int n2, RawValue rawValue) {
        return this._set(n2, rawValue == null ? this.nullNode() : this.rawValueNode(rawValue));
    }

    public ArrayNode set(int n2, short s2) {
        return this._set(n2, this.numberNode(s2));
    }

    public ArrayNode set(int n2, Short s2) {
        return this._set(n2, s2 == null ? this.nullNode() : this.numberNode((short)s2));
    }

    public ArrayNode set(int n2, int n3) {
        return this._set(n2, this.numberNode(n3));
    }

    public ArrayNode set(int n2, Integer n3) {
        return this._set(n2, n3 == null ? this.nullNode() : this.numberNode((int)n3));
    }

    public ArrayNode set(int n2, long l2) {
        return this._set(n2, this.numberNode(l2));
    }

    public ArrayNode set(int n2, Long l2) {
        return this._set(n2, l2 == null ? this.nullNode() : this.numberNode((long)l2));
    }

    public ArrayNode set(int n2, float f2) {
        return this._set(n2, this.numberNode(f2));
    }

    public ArrayNode set(int n2, Float f2) {
        return this._set(n2, f2 == null ? this.nullNode() : this.numberNode(f2.floatValue()));
    }

    public ArrayNode set(int n2, double d2) {
        return this._set(n2, this.numberNode(d2));
    }

    public ArrayNode set(int n2, Double d2) {
        return this._set(n2, d2 == null ? this.nullNode() : this.numberNode((double)d2));
    }

    public ArrayNode set(int n2, BigDecimal bigDecimal) {
        return this._set(n2, bigDecimal == null ? this.nullNode() : this.numberNode(bigDecimal));
    }

    public ArrayNode set(int n2, BigInteger bigInteger) {
        return this._set(n2, bigInteger == null ? this.nullNode() : this.numberNode(bigInteger));
    }

    public ArrayNode set(int n2, String string) {
        return this._set(n2, string == null ? this.nullNode() : this.textNode(string));
    }

    public ArrayNode set(int n2, boolean bl2) {
        return this._set(n2, this.booleanNode(bl2));
    }

    public ArrayNode set(int n2, Boolean bl2) {
        return this._set(n2, bl2 == null ? this.nullNode() : this.booleanNode(bl2));
    }

    public ArrayNode set(int n2, byte[] byArray) {
        return this._set(n2, byArray == null ? this.nullNode() : this.binaryNode(byArray));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof ArrayNode) {
            return this._children.equals(((ArrayNode)object)._children);
        }
        return false;
    }

    protected boolean _childrenEqual(ArrayNode arrayNode) {
        return this._children.equals(arrayNode._children);
    }

    @Override
    public int hashCode() {
        return this._children.hashCode();
    }

    protected ArrayNode _set(int n2, JsonNode jsonNode) {
        if (n2 < 0 || n2 >= this._children.size()) {
            throw new IndexOutOfBoundsException("Illegal index " + n2 + ", array size " + this.size());
        }
        this._children.set(n2, jsonNode);
        return this;
    }

    protected ArrayNode _add(JsonNode jsonNode) {
        this._children.add(jsonNode);
        return this;
    }

    protected ArrayNode _insert(int n2, JsonNode jsonNode) {
        if (n2 < 0) {
            this._children.add(0, jsonNode);
        } else if (n2 >= this._children.size()) {
            this._children.add(jsonNode);
        } else {
            this._children.add(n2, jsonNode);
        }
        return this;
    }
}

