/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind;

import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.EnumNamingStrategy;

public class EnumNamingStrategies {
    private EnumNamingStrategies() {
    }

    public static class CamelCaseStrategy
    implements EnumNamingStrategy {
        public static final CamelCaseStrategy INSTANCE = new CamelCaseStrategy();

        @Override
        public String convertEnumToExternalName(String string) {
            if (string == null) {
                return null;
            }
            String string2 = "_";
            StringBuilder stringBuilder = null;
            int n2 = 0;
            int n3 = -1;
            do {
                if ((n3 = CamelCaseStrategy.indexIn(string, n3 + 1)) == -1) continue;
                if (n2 == 0) {
                    stringBuilder = new StringBuilder(string.length() + 4 * "_".length());
                    stringBuilder.append(CamelCaseStrategy.toLowerCase(string.substring(n2, n3)));
                } else {
                    stringBuilder.append(CamelCaseStrategy.normalizeWord(string.substring(n2, n3)));
                }
                n2 = n3 + "_".length();
            } while (n3 != -1);
            if (n2 == 0) {
                return CamelCaseStrategy.toLowerCase(string);
            }
            stringBuilder.append(CamelCaseStrategy.normalizeWord(string.substring(n2)));
            return stringBuilder.toString();
        }

        private static int indexIn(CharSequence charSequence, int n2) {
            int n3 = charSequence.length();
            for (int i2 = n2; i2 < n3; ++i2) {
                if ('_' != charSequence.charAt(i2)) continue;
                return i2;
            }
            return -1;
        }

        private static String normalizeWord(String string) {
            int n2 = string.length();
            if (n2 == 0) {
                return string;
            }
            return new StringBuilder(n2).append(CamelCaseStrategy.charToUpperCaseIfLower(string.charAt(0))).append(CamelCaseStrategy.toLowerCase(string.substring(1))).toString();
        }

        private static String toLowerCase(String string) {
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(CamelCaseStrategy.charToLowerCaseIfUpper(string.charAt(i2)));
            }
            return stringBuilder.toString();
        }

        private static char charToUpperCaseIfLower(char c2) {
            return Character.isLowerCase(c2) ? Character.toUpperCase(c2) : c2;
        }

        private static char charToLowerCaseIfUpper(char c2) {
            return Character.isUpperCase(c2) ? Character.toLowerCase(c2) : c2;
        }
    }
}

