/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io;

import java.io.IOException;
import java.io.Writer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.util.BufferRecycler;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.util.TextBuffer;

public final class SegmentedStringWriter
extends Writer
implements BufferRecycler.Gettable {
    private final TextBuffer _buffer;

    public SegmentedStringWriter(BufferRecycler bufferRecycler) {
        this._buffer = new TextBuffer(bufferRecycler);
    }

    @Override
    public BufferRecycler bufferRecycler() {
        return this._buffer.bufferRecycler();
    }

    @Override
    public Writer append(char c2) throws IOException {
        this.write(c2);
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence) throws IOException {
        String string = charSequence.toString();
        this._buffer.append(string, 0, string.length());
        return this;
    }

    @Override
    public Writer append(CharSequence charSequence, int n2, int n3) throws IOException {
        String string = charSequence.subSequence(n2, n3).toString();
        this._buffer.append(string, 0, string.length());
        return this;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this._buffer.append(cArray, 0, cArray.length);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        this._buffer.append(cArray, n2, n3);
    }

    @Override
    public void write(int n2) throws IOException {
        this._buffer.append((char)n2);
    }

    @Override
    public void write(String string) throws IOException {
        this._buffer.append(string, 0, string.length());
    }

    @Override
    public void write(String string, int n2, int n3) throws IOException {
        this._buffer.append(string, n2, n3);
    }

    public String getAndClear() throws IOException {
        String string = this._buffer.contentsAsString();
        this._buffer.releaseBuffers();
        return string;
    }
}

