/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io;

import java.math.BigDecimal;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.io.doubleparser.JavaBigDecimalParser;

public final class BigDecimalParser {
    static final int MAX_CHARS_TO_REPORT = 1000;

    private BigDecimalParser() {
    }

    public static BigDecimal parse(String string) {
        return BigDecimalParser.parse(string.toCharArray());
    }

    public static BigDecimal parse(char[] cArray, int n2, int n3) {
        try {
            if (n3 < 500) {
                return new BigDecimal(cArray, n2, n3);
            }
            return JavaBigDecimalParser.parseBigDecimal(cArray, n2, n3);
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            throw BigDecimalParser._parseFailure(runtimeException, new String(cArray, n2, n3));
        }
    }

    public static BigDecimal parse(char[] cArray) {
        return BigDecimalParser.parse(cArray, 0, cArray.length);
    }

    public static BigDecimal parseWithFastParser(String string) {
        try {
            return JavaBigDecimalParser.parseBigDecimal(string);
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            throw BigDecimalParser._parseFailure(runtimeException, string);
        }
    }

    public static BigDecimal parseWithFastParser(char[] cArray, int n2, int n3) {
        try {
            return JavaBigDecimalParser.parseBigDecimal(cArray, n2, n3);
        }
        catch (ArithmeticException | NumberFormatException runtimeException) {
            throw BigDecimalParser._parseFailure(runtimeException, new String(cArray, n2, n3));
        }
    }

    private static NumberFormatException _parseFailure(Exception exception, String string) {
        String string2 = exception.getMessage();
        if (string2 == null) {
            string2 = "Not a valid number representation";
        }
        String string3 = BigDecimalParser._getValueDesc(string);
        return new NumberFormatException("Value " + string3 + " can not be deserialized as `java.math.BigDecimal`, reason: " + string2);
    }

    private static String _getValueDesc(String string) {
        int n2 = string.length();
        if (n2 <= 1000) {
            return String.format("\"%s\"", string);
        }
        return String.format("\"%s\" (truncated to %d chars (from %d))", string.substring(0, 1000), 1000, n2);
    }
}

