/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.filter;

import java.io.IOException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonProcessingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonStreamContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.filter.TokenFilter;

public class TokenFilterContext
extends JsonStreamContext {
    protected final TokenFilterContext _parent;
    protected TokenFilterContext _child;
    protected String _currentName;
    protected TokenFilter _filter;
    protected boolean _startHandled;
    protected boolean _needToHandleName;

    protected TokenFilterContext(int n2, TokenFilterContext tokenFilterContext, TokenFilter tokenFilter, boolean bl2) {
        this._type = n2;
        this._parent = tokenFilterContext;
        this._nestingDepth = tokenFilterContext == null ? 0 : tokenFilterContext._nestingDepth + 1;
        this._filter = tokenFilter;
        this._index = -1;
        this._startHandled = bl2;
        this._needToHandleName = false;
    }

    protected TokenFilterContext reset(int n2, TokenFilter tokenFilter, boolean bl2) {
        this._type = n2;
        this._filter = tokenFilter;
        this._index = -1;
        this._currentName = null;
        this._startHandled = bl2;
        this._needToHandleName = false;
        return this;
    }

    public static TokenFilterContext createRootContext(TokenFilter tokenFilter) {
        return new TokenFilterContext(0, null, tokenFilter, true);
    }

    public TokenFilterContext createChildArrayContext(TokenFilter tokenFilter, boolean bl2) {
        TokenFilterContext tokenFilterContext = this._child;
        if (tokenFilterContext == null) {
            this._child = tokenFilterContext = new TokenFilterContext(1, this, tokenFilter, bl2);
            return tokenFilterContext;
        }
        return tokenFilterContext.reset(1, tokenFilter, bl2);
    }

    public TokenFilterContext createChildObjectContext(TokenFilter tokenFilter, boolean bl2) {
        TokenFilterContext tokenFilterContext = this._child;
        if (tokenFilterContext == null) {
            this._child = tokenFilterContext = new TokenFilterContext(2, this, tokenFilter, bl2);
            return tokenFilterContext;
        }
        return tokenFilterContext.reset(2, tokenFilter, bl2);
    }

    public TokenFilter setFieldName(String string) throws JsonProcessingException {
        this._currentName = string;
        this._needToHandleName = true;
        return this._filter;
    }

    public TokenFilter checkValue(TokenFilter tokenFilter) {
        if (this._type == 2) {
            return tokenFilter;
        }
        int n2 = ++this._index;
        if (this._type == 1) {
            return tokenFilter.includeElement(n2);
        }
        return tokenFilter.includeRootValue(n2);
    }

    public void ensureFieldNameWritten(JsonGenerator jsonGenerator) throws IOException {
        if (this._needToHandleName) {
            this._needToHandleName = false;
            jsonGenerator.writeFieldName(this._currentName);
        }
    }

    public void writePath(JsonGenerator jsonGenerator) throws IOException {
        if (this._filter == null || this._filter == TokenFilter.INCLUDE_ALL) {
            return;
        }
        if (this._parent != null) {
            this._parent._writePath(jsonGenerator);
        }
        if (this._startHandled) {
            if (this._needToHandleName) {
                jsonGenerator.writeFieldName(this._currentName);
            }
        } else {
            this._startHandled = true;
            if (this._type == 2) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeFieldName(this._currentName);
            } else if (this._type == 1) {
                jsonGenerator.writeStartArray();
            }
        }
    }

    private void _writePath(JsonGenerator jsonGenerator) throws IOException {
        if (this._filter == null || this._filter == TokenFilter.INCLUDE_ALL) {
            return;
        }
        if (this._parent != null) {
            this._parent._writePath(jsonGenerator);
        }
        if (this._startHandled) {
            if (this._needToHandleName) {
                this._needToHandleName = false;
                jsonGenerator.writeFieldName(this._currentName);
            }
        } else {
            this._startHandled = true;
            if (this._type == 2) {
                jsonGenerator.writeStartObject();
                if (this._needToHandleName) {
                    this._needToHandleName = false;
                    jsonGenerator.writeFieldName(this._currentName);
                }
            } else if (this._type == 1) {
                jsonGenerator.writeStartArray();
            }
        }
    }

    public TokenFilterContext closeArray(JsonGenerator jsonGenerator) throws IOException {
        if (this._startHandled) {
            jsonGenerator.writeEndArray();
        } else if (this._filter != null && this._filter != TokenFilter.INCLUDE_ALL && this._filter.includeEmptyArray(this.hasCurrentIndex())) {
            if (this._parent != null) {
                this._parent._writePath(jsonGenerator);
            }
            jsonGenerator.writeStartArray();
            jsonGenerator.writeEndArray();
        }
        if (this._filter != null && this._filter != TokenFilter.INCLUDE_ALL) {
            this._filter.filterFinishArray();
        }
        return this._parent;
    }

    public TokenFilterContext closeObject(JsonGenerator jsonGenerator) throws IOException {
        if (this._startHandled) {
            jsonGenerator.writeEndObject();
        } else if (this._filter != null && this._filter != TokenFilter.INCLUDE_ALL && this._filter.includeEmptyObject(this.hasCurrentName())) {
            if (this._parent != null) {
                this._parent._writePath(jsonGenerator);
            }
            jsonGenerator.writeStartObject();
            jsonGenerator.writeEndObject();
        }
        if (this._filter != null && this._filter != TokenFilter.INCLUDE_ALL) {
            this._filter.filterFinishObject();
        }
        return this._parent;
    }

    public void skipParentChecks() {
        this._filter = null;
        TokenFilterContext tokenFilterContext = this._parent;
        while (tokenFilterContext != null) {
            tokenFilterContext._filter = null;
            tokenFilterContext = tokenFilterContext._parent;
        }
    }

    @Override
    public Object getCurrentValue() {
        return null;
    }

    @Override
    public void setCurrentValue(Object object) {
    }

    @Override
    public final TokenFilterContext getParent() {
        return this._parent;
    }

    @Override
    public final String getCurrentName() {
        return this._currentName;
    }

    @Override
    public boolean hasCurrentName() {
        return this._currentName != null;
    }

    public TokenFilter getFilter() {
        return this._filter;
    }

    public boolean isStartHandled() {
        return this._startHandled;
    }

    public JsonToken nextTokenToRead() {
        if (!this._startHandled) {
            this._startHandled = true;
            if (this._type == 2) {
                return JsonToken.START_OBJECT;
            }
            return JsonToken.START_ARRAY;
        }
        if (this._needToHandleName && this._type == 2) {
            this._needToHandleName = false;
            return JsonToken.FIELD_NAME;
        }
        return null;
    }

    public TokenFilterContext findChildOf(TokenFilterContext tokenFilterContext) {
        if (this._parent == tokenFilterContext) {
            return this;
        }
        TokenFilterContext tokenFilterContext2 = this._parent;
        while (tokenFilterContext2 != null) {
            TokenFilterContext tokenFilterContext3 = tokenFilterContext2._parent;
            if (tokenFilterContext3 == tokenFilterContext) {
                return tokenFilterContext2;
            }
            tokenFilterContext2 = tokenFilterContext3;
        }
        return null;
    }

    protected void appendDesc(StringBuilder stringBuilder) {
        if (this._parent != null) {
            this._parent.appendDesc(stringBuilder);
        }
        if (this._type == 2) {
            stringBuilder.append('{');
            if (this._currentName != null) {
                stringBuilder.append('\"');
                stringBuilder.append(this._currentName);
                stringBuilder.append('\"');
            } else {
                stringBuilder.append('?');
            }
            stringBuilder.append('}');
        } else if (this._type == 1) {
            stringBuilder.append('[');
            stringBuilder.append(this.getCurrentIndex());
            stringBuilder.append(']');
        } else {
            stringBuilder.append("/");
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        this.appendDesc(stringBuilder);
        return stringBuilder.toString();
    }
}

