/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.util;

import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.util.JacksonFeature;

public final class JacksonFeatureSet<F extends JacksonFeature> {
    protected int _enabled;

    protected JacksonFeatureSet(int n2) {
        this._enabled = n2;
    }

    public static <F extends JacksonFeature> JacksonFeatureSet<F> fromDefaults(F[] FArray) {
        if (FArray.length > 31) {
            String string = FArray[0].getClass().getName();
            throw new IllegalArgumentException(String.format("Can not use type `%s` with JacksonFeatureSet: too many entries (%d > 31)", string, FArray.length));
        }
        int n2 = 0;
        for (F f2 : FArray) {
            if (!f2.enabledByDefault()) continue;
            n2 |= f2.getMask();
        }
        return new JacksonFeatureSet<F>(n2);
    }

    public static <F extends JacksonFeature> JacksonFeatureSet<F> fromBitmask(int n2) {
        return new JacksonFeatureSet<F>(n2);
    }

    public JacksonFeatureSet<F> with(F f2) {
        int n2 = this._enabled | f2.getMask();
        return n2 == this._enabled ? this : new JacksonFeatureSet<F>(n2);
    }

    public JacksonFeatureSet<F> without(F f2) {
        int n2 = this._enabled & ~f2.getMask();
        return n2 == this._enabled ? this : new JacksonFeatureSet<F>(n2);
    }

    public boolean isEnabled(F f2) {
        return (f2.getMask() & this._enabled) != 0;
    }

    public int asBitmask() {
        return this._enabled;
    }
}

