/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.json;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.ReadValueCallback;
import macromedia.jdbc.sqlserver.externals.com.azure.json.implementation.jackson.core.io.JsonStringEncoder;

public abstract class JsonReader
implements Closeable {
    private static final JsonStringEncoder ENCODER = JsonStringEncoder.getInstance();

    public abstract JsonToken currentToken();

    public abstract JsonToken nextToken() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public final boolean isStartArrayOrObject() {
        return JsonReader.isStartArrayOrObject(this.currentToken());
    }

    private static boolean isStartArrayOrObject(JsonToken jsonToken) {
        return jsonToken == JsonToken.START_ARRAY || jsonToken == JsonToken.START_OBJECT;
    }

    public final boolean isEndArrayOrObject() {
        return JsonReader.isEndArrayOrObject(this.currentToken());
    }

    private static boolean isEndArrayOrObject(JsonToken jsonToken) {
        return jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT;
    }

    public abstract byte[] getBinary() throws IOException;

    public abstract boolean getBoolean() throws IOException;

    public abstract float getFloat() throws IOException;

    public abstract double getDouble() throws IOException;

    public abstract int getInt() throws IOException;

    public abstract long getLong() throws IOException;

    public abstract String getString() throws IOException;

    public abstract String getFieldName() throws IOException;

    public final <T> T getNullable(ReadValueCallback<JsonReader, T> readValueCallback) throws IOException {
        return this.currentToken() == JsonToken.NULL ? null : (T)readValueCallback.read(this);
    }

    public abstract void skipChildren() throws IOException;

    public abstract JsonReader bufferObject() throws IOException;

    public abstract boolean isResetSupported();

    public abstract JsonReader reset() throws IOException;

    public final String readChildren() throws IOException {
        return this.readInternal(new StringBuilder(), true, false).toString();
    }

    public final void readChildren(StringBuilder stringBuilder) throws IOException {
        this.readInternal(stringBuilder, true, false);
    }

    public final String readRemainingFieldsAsJsonObject() throws IOException {
        return this.readInternal(new StringBuilder(), false, true).toString();
    }

    public final void readRemainingFieldsAsJsonObject(StringBuilder stringBuilder) throws IOException {
        this.readInternal(stringBuilder, false, true);
    }

    private StringBuilder readInternal(StringBuilder stringBuilder, boolean bl2, boolean bl3) throws IOException {
        boolean bl4;
        Objects.requireNonNull(stringBuilder, "The 'buffer' used to read the JSON object cannot be null.");
        JsonToken jsonToken = this.currentToken();
        boolean bl5 = bl4 = jsonToken == JsonToken.START_OBJECT || bl2 && jsonToken == JsonToken.START_ARRAY || bl3 && jsonToken == JsonToken.FIELD_NAME;
        if (!bl4) {
            return stringBuilder;
        }
        if (jsonToken == JsonToken.FIELD_NAME) {
            stringBuilder.append("{\"");
            ENCODER.quoteAsString(this.getFieldName(), stringBuilder);
            stringBuilder.append("\":");
            jsonToken = this.nextToken();
        }
        this.appendJson(stringBuilder, jsonToken);
        int n2 = 1;
        while (n2 > 0) {
            JsonToken jsonToken2 = jsonToken;
            jsonToken = this.nextToken();
            if (JsonReader.isStartArrayOrObject(jsonToken)) {
                ++n2;
            } else if (JsonReader.isEndArrayOrObject(jsonToken)) {
                --n2;
            } else if (jsonToken == null) {
                return stringBuilder;
            }
            if (!JsonReader.isStartArrayOrObject(jsonToken2) && !JsonReader.isEndArrayOrObject(jsonToken) && jsonToken2 != JsonToken.FIELD_NAME) {
                stringBuilder.append(',');
            }
            this.appendJson(stringBuilder, jsonToken);
        }
        return stringBuilder;
    }

    private void appendJson(StringBuilder stringBuilder, JsonToken jsonToken) throws IOException {
        if (jsonToken == JsonToken.FIELD_NAME) {
            stringBuilder.append("\"");
            ENCODER.quoteAsString(this.getFieldName(), stringBuilder);
            stringBuilder.append("\":");
        } else if (jsonToken == JsonToken.STRING) {
            stringBuilder.append("\"");
            ENCODER.quoteAsString(this.getString(), stringBuilder);
            stringBuilder.append("\"");
        } else {
            stringBuilder.append(this.getText());
        }
    }

    public final <T> T readObject(ReadValueCallback<JsonReader, T> readValueCallback) throws IOException {
        return this.readMapOrObject(readValueCallback, false);
    }

    public final <T> List<T> readArray(ReadValueCallback<JsonReader, T> readValueCallback) throws IOException {
        JsonToken jsonToken = this.currentToken();
        if (jsonToken == null) {
            jsonToken = this.nextToken();
        }
        if (jsonToken == JsonToken.NULL || jsonToken == null) {
            return null;
        }
        if (jsonToken != JsonToken.START_ARRAY) {
            throw new IllegalStateException("Unexpected token to begin array deserialization: " + (Object)((Object)jsonToken));
        }
        LinkedList<T> linkedList = new LinkedList<T>();
        while (this.nextToken() != JsonToken.END_ARRAY) {
            linkedList.add(readValueCallback.read(this));
        }
        return linkedList;
    }

    public final <T> Map<String, T> readMap(ReadValueCallback<JsonReader, T> readValueCallback) throws IOException {
        return this.readMapOrObject(jsonReader -> {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            while (this.nextToken() != JsonToken.END_OBJECT) {
                String string = this.getFieldName();
                this.nextToken();
                linkedHashMap.put(string, readValueCallback.read(this));
            }
            return linkedHashMap;
        }, true);
    }

    private <T> T readMapOrObject(ReadValueCallback<JsonReader, T> readValueCallback, boolean bl2) throws IOException {
        JsonToken jsonToken = this.currentToken();
        if (jsonToken == null) {
            jsonToken = this.nextToken();
        }
        if (jsonToken == JsonToken.NULL || jsonToken == null) {
            return null;
        }
        if (jsonToken != JsonToken.START_OBJECT) {
            String string = bl2 ? "map" : "object";
            throw new IllegalStateException("Unexpected token to begin " + string + " deserialization: " + (Object)((Object)jsonToken));
        }
        return readValueCallback.read(this);
    }

    public final Object readUntyped() throws IOException {
        JsonToken jsonToken = this.currentToken();
        if (jsonToken == null) {
            jsonToken = this.nextToken();
        }
        if (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT || jsonToken == JsonToken.FIELD_NAME) {
            throw new IllegalStateException("Unexpected token to begin an untyped field: " + (Object)((Object)jsonToken));
        }
        return this.readUntypedHelper(0);
    }

    private Object readUntypedHelper(int n2) throws IOException {
        if (n2 >= 999) {
            throw new IllegalStateException("Untyped object exceeded allowed object nested depth of 1000.");
        }
        JsonToken jsonToken = this.currentToken();
        if (jsonToken == JsonToken.NULL || jsonToken == null) {
            return null;
        }
        if (jsonToken == JsonToken.BOOLEAN) {
            return this.getBoolean();
        }
        if (jsonToken == JsonToken.NUMBER) {
            String string = this.getText();
            if ("INF".equals(string) || "Infinity".equals(string) || "-INF".equals(string) || "-Infinity".equals(string) || "NaN".equals(string)) {
                return string;
            }
            if (string.contains(".")) {
                return Double.parseDouble(string);
            }
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return Long.parseLong(string);
            }
        }
        if (jsonToken == JsonToken.STRING) {
            return this.getString();
        }
        if (jsonToken == JsonToken.START_ARRAY) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (this.nextToken() != JsonToken.END_ARRAY) {
                arrayList.add(this.readUntypedHelper(n2 + 1));
            }
            return arrayList;
        }
        if (jsonToken == JsonToken.START_OBJECT) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            while (this.nextToken() != JsonToken.END_OBJECT) {
                String string = this.getFieldName();
                this.nextToken();
                Object object = this.readUntypedHelper(n2 + 1);
                linkedHashMap.put(string, object);
            }
            return linkedHashMap;
        }
        throw new IllegalStateException("Unknown token type while reading an untyped field: " + (Object)((Object)jsonToken));
    }

    public final String getText() throws IOException {
        return this.getTextInternal(false);
    }

    public String getRawText() throws IOException {
        return this.getTextInternal(true);
    }

    private String getTextInternal(boolean bl2) throws IOException {
        JsonToken jsonToken = this.currentToken();
        if (jsonToken == null) {
            throw new IllegalStateException("Current token cannot be null.");
        }
        switch (jsonToken) {
            case START_OBJECT: {
                return "{";
            }
            case END_OBJECT: {
                return "}";
            }
            case START_ARRAY: {
                return "[";
            }
            case END_ARRAY: {
                return "]";
            }
            case FIELD_NAME: {
                return bl2 ? new String(ENCODER.quoteAsUTF8(this.getFieldName()), StandardCharsets.UTF_8) : this.getFieldName();
            }
            case BOOLEAN: {
                return String.valueOf(this.getBoolean());
            }
            case NUMBER: {
                return this.getString();
            }
            case STRING: {
                return bl2 ? new String(ENCODER.quoteAsUTF8(this.getString()), StandardCharsets.UTF_8) : this.getString();
            }
            case NULL: {
                return "null";
            }
        }
        return "";
    }
}

