/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util;

import java.util.ArrayList;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;

public final class LoggingUtil {
    public static void logTokenSuccess(ClientLogger clientLogger, TokenRequestContext tokenRequestContext) {
        clientLogger.log(LogLevel.VERBOSE, () -> String.format("Azure Identity => getToken() result for scopes [%s]: SUCCESS", CoreUtils.stringJoin(", ", tokenRequestContext.getScopes())));
    }

    public static void logTokenError(ClientLogger clientLogger, IdentityClientOptions identityClientOptions, TokenRequestContext tokenRequestContext, Throwable throwable) {
        LoggingUtil.logError(clientLogger, identityClientOptions, () -> String.format("Azure Identity => ERROR in getToken() call for scopes [%s]: %s", CoreUtils.stringJoin(", ", tokenRequestContext.getScopes()), throwable == null ? "" : throwable.getMessage()));
    }

    public static void logAvailableEnvironmentVariables(ClientLogger clientLogger, Configuration configuration) {
        String string = configuration.get("MSI_ENDPOINT");
        String string2 = configuration.get("MSI_SECRET");
        String string3 = configuration.get("AZURE_CLIENT_ID");
        String string4 = configuration.get("AZURE_TENANT_ID");
        String string5 = configuration.get("AZURE_CLIENT_SECRET");
        String string6 = configuration.get("AZURE_CLIENT_CERTIFICATE_PATH");
        String string7 = configuration.get("AZURE_USERNAME");
        String string8 = configuration.get("AZURE_PASSWORD");
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            arrayList.add("MSI_ENDPOINT");
        }
        if (string2 != null) {
            arrayList.add("MSI_SECRET");
        }
        if (string3 != null) {
            arrayList.add("AZURE_CLIENT_ID");
        }
        if (string4 != null) {
            arrayList.add("AZURE_TENANT_ID");
        }
        if (string5 != null) {
            arrayList.add("AZURE_CLIENT_SECRET");
        }
        if (string6 != null) {
            arrayList.add("AZURE_CLIENT_CERTIFICATE_PATH");
        }
        if (string7 != null) {
            arrayList.add("AZURE_USERNAME");
        }
        if (string8 != null) {
            arrayList.add("AZURE_PASSWORD");
        }
        clientLogger.verbose("Azure Identity => Found the following environment variables: {}", String.join((CharSequence)", ", arrayList));
    }

    private LoggingUtil() {
    }

    public static CredentialUnavailableException logCredentialUnavailableException(ClientLogger clientLogger, IdentityClientOptions identityClientOptions, CredentialUnavailableException credentialUnavailableException) {
        clientLogger.log(identityClientOptions.getIdentityLogOptionsImpl().getRuntimeExceptionLogLevel(), credentialUnavailableException::getMessage, credentialUnavailableException);
        return credentialUnavailableException;
    }

    public static void logError(ClientLogger clientLogger, IdentityClientOptions identityClientOptions, String string) {
        clientLogger.log(identityClientOptions.getIdentityLogOptionsImpl().getRuntimeExceptionLogLevel(), () -> string);
    }

    public static void logError(ClientLogger clientLogger, IdentityClientOptions identityClientOptions, Supplier<String> supplier) {
        clientLogger.log(identityClientOptions.getIdentityLogOptionsImpl().getRuntimeExceptionLogLevel(), supplier);
    }
}

