/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import com.microsoft.aad.msal4jextensions.PersistenceSettings;
import com.microsoft.aad.msal4jextensions.PersistenceTokenCacheAccessAspect;
import com.microsoft.aad.msal4jextensions.persistence.linux.KeyRingAccessException;
import com.sun.jna.Platform;
import java.nio.file.Path;
import java.nio.file.Paths;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.ClientAuthenticationException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ITokenCacheAccessAspect;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ITokenCacheAccessContext;

public class PersistentTokenCacheImpl
implements ITokenCacheAccessAspect {
    private static final String DEFAULT_CACHE_FILE_NAME = "msal.cache";
    private static final String CAE_ENABLED_CACHE_SUFFIX = ".cae";
    private static final String CAE_DISABLED_CACHE_SUFFIX = ".nocae";
    private static final String DEFAULT_CONFIDENTIAL_CACHE_FILE_NAME = "msal.confidential.cache";
    static final Path DEFAULT_CACHE_FILE_PATH = Platform.isWindows() ? Paths.get(System.getProperty("user.home"), "AppData", "Local", ".IdentityService") : Paths.get(System.getProperty("user.home"), ".IdentityService");
    private static final String DEFAULT_KEYCHAIN_SERVICE = "Microsoft.Developer.IdentityService";
    private static final String DEFAULT_KEYCHAIN_ACCOUNT = "MSALCache";
    private static final String DEFAULT_CONFIDENTIAL_KEYCHAIN_ACCOUNT = "MSALConfidentialCache";
    private static final String DEFAULT_KEYRING_NAME = "default";
    private static final String DEFAULT_KEYRING_SCHEMA = "msal.cache";
    private static final String DEFAULT_KEYRING_ITEM_NAME = "MSALCache";
    private static final String DEFAULT_CONFIDENTIAL_KEYRING_ITEM_NAME = "MSALConfidentialCache";
    private static final String DEFAULT_KEYRING_ATTR_NAME = "MsalClientID";
    private static final String DEFAULT_KEYRING_ATTR_VALUE = "Microsoft.Developer.IdentityService";
    private static final ClientLogger LOGGER = new ClientLogger(PersistentTokenCacheImpl.class);
    private boolean allowUnencryptedStorage;
    private String name;
    private PersistenceTokenCacheAccessAspect cacheAccessAspect;
    private boolean caeEnabled;

    public PersistentTokenCacheImpl(boolean bl2) {
        this.caeEnabled = bl2;
    }

    public PersistentTokenCacheImpl setAllowUnencryptedStorage(boolean bl2) {
        this.allowUnencryptedStorage = bl2;
        return this;
    }

    public PersistentTokenCacheImpl setName(String string) {
        this.name = string;
        return this;
    }

    boolean registerCache() {
        try {
            PersistenceSettings persistenceSettings = this.getPersistenceSettings();
            this.cacheAccessAspect = new PersistenceTokenCacheAccessAspect(persistenceSettings);
            return true;
        }
        catch (Throwable throwable) {
            throw LOGGER.logExceptionAsError(new ClientAuthenticationException("Shared token cache is unavailable in this environment.", null, throwable));
        }
    }

    @Override
    public void beforeCacheAccess(ITokenCacheAccessContext iTokenCacheAccessContext) {
        this.cacheAccessAspect.beforeCacheAccess(iTokenCacheAccessContext);
    }

    @Override
    public void afterCacheAccess(ITokenCacheAccessContext iTokenCacheAccessContext) {
        this.cacheAccessAspect.afterCacheAccess(iTokenCacheAccessContext);
    }

    private PersistenceSettings getPersistenceSettings() {
        PersistenceSettings.Builder builder = PersistenceSettings.builder((String)this.getCacheName(this.name != null ? this.name : "msal.cache"), (Path)DEFAULT_CACHE_FILE_PATH);
        if (Platform.isMac()) {
            builder.setMacKeychain("Microsoft.Developer.IdentityService", this.getCacheName(this.name != null ? this.name : "MSALCache"));
            return builder.build();
        }
        if (Platform.isLinux()) {
            try {
                builder.setLinuxKeyring(DEFAULT_KEYRING_NAME, "msal.cache", this.getCacheName(this.name != null ? this.name : "MSALCache"), DEFAULT_KEYRING_ATTR_NAME, "Microsoft.Developer.IdentityService", null, null);
                return builder.build();
            }
            catch (KeyRingAccessException keyRingAccessException) {
                if (!this.allowUnencryptedStorage) {
                    throw LOGGER.logExceptionAsError((RuntimeException)((Object)keyRingAccessException));
                }
                builder.setLinuxUseUnprotectedFileAsCacheStorage(true);
                return builder.build();
            }
        }
        return builder.build();
    }

    private String getCacheName(String string) {
        if (this.caeEnabled) {
            return string + CAE_ENABLED_CACHE_SUFFIX;
        }
        return string + CAE_DISABLED_CACHE_SUFFIX;
    }
}

