/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.HashMap;
import java.util.stream.Collectors;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipeline;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Header;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpClient;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpResponse;

class HttpPipelineAdapter
implements IHttpClient {
    private static final ClientLogger CLIENT_LOGGER = new ClientLogger(HttpPipelineAdapter.class);
    private static final JsonFactory JSON_FACTORY = new JsonFactory();
    private static final String ACCOUNT_IDENTIFIER_LOG_MESSAGE = "[Authenticated account] Client ID: {0}, Tenant ID: {1}, User Principal Name: {2}, Object ID (user): {3})";
    private static final String APPLICATION_IDENTIFIER = "Application Identifier";
    private static final String OBJECT_ID = "Object Id";
    private static final String TENANT_ID = "Tenant Id";
    private static final String USER_PRINCIPAL_NAME = "User Principal Name";
    private static final String ACCESS_TOKEN_JSON_KEY = "access_token";
    private static final String APPLICATION_ID_JSON_KEY = "appid";
    private static final String OBJECT_ID_JSON_KEY = "oid";
    private static final String TENANT_ID_JSON_KEY = "tid";
    private static final String USER_PRINCIPAL_NAME_JSON_KEY = "upn";
    private final HttpPipeline httpPipeline;
    private IdentityClientOptions identityClientOptions;

    HttpPipelineAdapter(HttpPipeline httpPipeline, IdentityClientOptions identityClientOptions) {
        this.httpPipeline = httpPipeline;
        this.identityClientOptions = identityClientOptions;
    }

    @Override
    public IHttpResponse send(HttpRequest httpRequest) {
        macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest httpRequest2 = new macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest(HttpMethod.valueOf(httpRequest.httpMethod().name()), httpRequest.url());
        if (httpRequest.headers() != null) {
            httpRequest2.setHeaders(new HttpHeaders(httpRequest.headers()));
        }
        if (httpRequest.body() != null) {
            httpRequest2.setBody(httpRequest.body());
        }
        HttpResponse httpResponse = this.httpPipeline.sendSync(httpRequest2, Context.NONE);
        String string = httpResponse.getBodyAsBinaryData().toString();
        this.logAccountIdentifiersIfConfigured(string);
        macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpResponse httpResponse2 = new macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpResponse().statusCode(httpResponse.getStatusCode());
        if (!CoreUtils.isNullOrEmpty(string)) {
            httpResponse2.body(string);
        }
        httpResponse2.addHeaders(httpResponse.getHeaders().stream().collect(Collectors.toMap(Header::getName, Header::getValuesList)));
        return httpResponse2;
    }

    private void logAccountIdentifiersIfConfigured(String string) {
        if (this.identityClientOptions == null || !this.identityClientOptions.getIdentityLogOptionsImpl().isLoggingAccountIdentifiersAllowed()) {
            return;
        }
        try {
            String[] stringArray;
            JsonParser jsonParser = JSON_FACTORY.createParser(string);
            String string2 = this.getTargetFieldValueFromJsonParser(jsonParser, ACCESS_TOKEN_JSON_KEY);
            jsonParser.close();
            if (string2 != null && (stringArray = string2.split("\\.")).length > 1) {
                byte[] byArray = Base64.getDecoder().decode(stringArray[1]);
                String string3 = new String(byArray, StandardCharsets.UTF_8);
                JsonParser jsonParser2 = JSON_FACTORY.createParser(string3);
                HashMap<String, String> hashMap = this.parseJsonIntoMap(jsonParser2);
                jsonParser2.close();
                String string4 = hashMap.containsKey(APPLICATION_ID_JSON_KEY) ? hashMap.get(APPLICATION_ID_JSON_KEY) : null;
                String string5 = hashMap.containsKey(OBJECT_ID_JSON_KEY) ? hashMap.get(OBJECT_ID_JSON_KEY) : null;
                String string6 = hashMap.containsKey(TENANT_ID_JSON_KEY) ? hashMap.get(TENANT_ID_JSON_KEY) : null;
                String string7 = hashMap.containsKey(USER_PRINCIPAL_NAME_JSON_KEY) ? hashMap.get(USER_PRINCIPAL_NAME_JSON_KEY) : null;
                CLIENT_LOGGER.log(LogLevel.INFORMATIONAL, () -> MessageFormat.format(ACCOUNT_IDENTIFIER_LOG_MESSAGE, this.getAccountIdentifierMessage(APPLICATION_IDENTIFIER, string4), this.getAccountIdentifierMessage(TENANT_ID, string6), this.getAccountIdentifierMessage(USER_PRINCIPAL_NAME, string7), this.getAccountIdentifierMessage(OBJECT_ID, string5)));
            }
        }
        catch (IOException iOException) {
            CLIENT_LOGGER.log(LogLevel.WARNING, () -> "allowLoggingAccountIdentifiers Log option was set, but the account information could not be logged.", iOException);
        }
    }

    private String getAccountIdentifierMessage(String string, String string2) {
        if (string2 == null) {
            return "No " + string + " available.";
        }
        return string2;
    }

    private String getTargetFieldValueFromJsonParser(JsonParser jsonParser, String string) throws IOException {
        while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
            String string2 = jsonParser.getCurrentName();
            if (!string.equals(string2)) continue;
            jsonParser.nextToken();
            return jsonParser.getText();
        }
        return null;
    }

    private HashMap<String, String> parseJsonIntoMap(JsonParser jsonParser) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonParser.getCurrentName() == null) {
            jsonToken = jsonParser.nextToken();
        }
        while (jsonToken != JsonToken.END_OBJECT) {
            String string = jsonParser.getCurrentName();
            jsonParser.nextToken();
            String string2 = jsonParser.getText();
            hashMap.put(string, string2);
            jsonToken = jsonParser.nextToken();
        }
        return hashMap;
    }
}

