/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.util.concurrent.ExecutorService;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialBuilderBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.EnvironmentCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;

public class EnvironmentCredentialBuilder
extends CredentialBuilderBase<EnvironmentCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(EnvironmentCredentialBuilder.class);
    private String authorityHost;

    public EnvironmentCredentialBuilder authorityHost(String string) {
        ValidationUtil.validateAuthHost(string, LOGGER);
        this.authorityHost = string;
        return this;
    }

    public EnvironmentCredentialBuilder executorService(ExecutorService executorService) {
        this.identityClientOptions.setExecutorService(executorService);
        return this;
    }

    public EnvironmentCredential build() {
        if (!CoreUtils.isNullOrEmpty(this.authorityHost)) {
            this.identityClientOptions.setAuthorityHost(this.authorityHost);
        }
        return new EnvironmentCredential(this.identityClientOptions);
    }
}

