/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.ClientCertificateCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.ClientSecretCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.CredentialUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.UsernamePasswordCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.LoggingUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class EnvironmentCredential
implements TokenCredential {
    private static final ClientLogger LOGGER = new ClientLogger(EnvironmentCredential.class);
    private final TokenCredential tokenCredential;
    private final IdentityClientOptions identityClientOptions;

    EnvironmentCredential(IdentityClientOptions identityClientOptions) {
        Configuration configuration = identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : identityClientOptions.getConfiguration();
        TokenCredential tokenCredential = null;
        this.identityClientOptions = identityClientOptions;
        String string = configuration.get("AZURE_CLIENT_ID");
        String string2 = configuration.get("AZURE_TENANT_ID");
        String string3 = configuration.get("AZURE_CLIENT_SECRET");
        String string4 = configuration.get("AZURE_CLIENT_CERTIFICATE_PATH");
        String string5 = configuration.get("AZURE_CLIENT_CERTIFICATE_PASSWORD");
        String string6 = configuration.get("AZURE_USERNAME");
        String string7 = configuration.get("AZURE_PASSWORD");
        if (CoreUtils.isNullOrEmpty(identityClientOptions.getAdditionallyAllowedTenants())) {
            identityClientOptions.setAdditionallyAllowedTenants(IdentityUtil.getAdditionalTenantsFromEnvironment(configuration));
        }
        ValidationUtil.validateTenantIdCharacterRange(string2, LOGGER);
        LoggingUtil.logAvailableEnvironmentVariables(LOGGER, configuration);
        if (this.verifyNotNull(string)) {
            if (this.verifyNotNull(string2)) {
                if (this.verifyNotNull(string3)) {
                    LOGGER.info("Azure Identity => EnvironmentCredential invoking ClientSecretCredential");
                    tokenCredential = new ClientSecretCredential(string2, string, string3, identityClientOptions);
                } else if (this.verifyNotNull(string4)) {
                    LOGGER.info("Azure Identity => EnvironmentCredential invoking ClientCertificateCredential");
                    tokenCredential = new ClientCertificateCredential(string2, string, string4, null, string5, identityClientOptions);
                } else {
                    LoggingUtil.logError(LOGGER, identityClientOptions, () -> String.format("Azure Identity => ERROR in EnvironmentCredential: Failed to create a ClientSecretCredential or ClientCertificateCredential. Missing required environment variable either %s or %s", "AZURE_CLIENT_SECRET", "AZURE_CLIENT_CERTIFICATE_PATH"));
                }
            } else if (this.verifyNotNull(string3) || this.verifyNotNull(string4)) {
                LoggingUtil.logError(LOGGER, identityClientOptions, () -> String.format("Azure Identity => ERROR in EnvironmentCredential: Failed to create a ClientSecretCredential or ClientCertificateCredential. Missing required environment variable %s", "AZURE_TENANT_ID"));
            }
            if (tokenCredential == null && this.verifyNotNull(string6, string7)) {
                LOGGER.info("Azure Identity => EnvironmentCredential invoking UsernamePasswordCredential");
                tokenCredential = new UsernamePasswordCredential(string, string2, string6, string7, identityClientOptions);
            } else if (this.verifyNotNull(string6) ^ this.verifyNotNull(string7)) {
                LoggingUtil.logError(LOGGER, identityClientOptions, () -> String.format("Azure Identity => ERROR in EnvironmentCredential: Failed to create a UsernamePasswordCredential. Missing required environment variable %s", string6 == null ? "AZURE_USERNAME" : "AZURE_PASSWORD"));
            }
            if (tokenCredential == null) {
                String string8 = String.format("Azure Identity => ERROR in EnvironmentCredential: Failed to determine an authentication scheme based on the available environment variables. Please specify %1$s and %2$s to authenticate through a ClientSecretCredential; %1$s and %3$s to authenticate through a ClientCertificateCredential; or %4$s and %5$s to authenticate through a UserPasswordCredential.", "AZURE_TENANT_ID", "AZURE_CLIENT_SECRET", "AZURE_CLIENT_CERTIFICATE_PATH", "AZURE_USERNAME", "AZURE_PASSWORD");
                LoggingUtil.logError(LOGGER, identityClientOptions, string8);
            }
        } else {
            LoggingUtil.logError(LOGGER, identityClientOptions, () -> String.format("Azure Identity => ERROR in EnvironmentCredential: Missing required environment variable %s", "AZURE_CLIENT_ID"));
        }
        this.tokenCredential = tokenCredential;
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext tokenRequestContext) {
        if (this.tokenCredential == null) {
            return Mono.error((Throwable)LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("EnvironmentCredential authentication unavailable. Environment variables are not fully configured.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/environmentcredential/troubleshoot")));
        }
        return this.tokenCredential.getToken(tokenRequestContext);
    }

    @Override
    public AccessToken getTokenSync(TokenRequestContext tokenRequestContext) {
        if (this.tokenCredential == null) {
            throw LoggingUtil.logCredentialUnavailableException(LOGGER, this.identityClientOptions, new CredentialUnavailableException("EnvironmentCredential authentication unavailable. Environment variables are not fully configured.To mitigate this issue, please refer to the troubleshooting guidelines here at https://aka.ms/azsdk/java/identity/environmentcredential/troubleshoot"));
        }
        return this.tokenCredential.getTokenSync(tokenRequestContext);
    }

    private boolean verifyNotNull(String ... stringArray) {
        for (String string : stringArray) {
            if (string != null) continue;
            return false;
        }
        return true;
    }
}

