/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Function;
import macromedia.jdbc.sqlserver.externals.com.azure.core.client.traits.HttpTrait;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpClient;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipeline;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelinePosition;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.ProxyOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpLogOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.CredentialBuilderBaseHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClientOptions;

public abstract class CredentialBuilderBase<T extends CredentialBuilderBase<T>>
implements HttpTrait<T> {
    private static final ClientLogger LOGGER = new ClientLogger(CredentialBuilderBase.class);
    IdentityClientOptions identityClientOptions = new IdentityClientOptions();

    CredentialBuilderBase() {
    }

    public T maxRetry(int n2) {
        this.identityClientOptions.setMaxRetry(n2);
        return (T)this;
    }

    public T retryTimeout(Function<Duration, Duration> function) {
        this.identityClientOptions.setRetryTimeout(function);
        return (T)this;
    }

    @Deprecated
    public T proxyOptions(ProxyOptions proxyOptions) {
        this.identityClientOptions.setProxyOptions(proxyOptions);
        return (T)this;
    }

    @Deprecated
    public T httpPipeline(HttpPipeline httpPipeline) {
        this.identityClientOptions.setHttpPipeline(httpPipeline);
        return (T)this;
    }

    @Override
    public T httpClient(HttpClient httpClient) {
        Objects.requireNonNull(httpClient);
        this.identityClientOptions.setHttpClient(httpClient);
        return (T)this;
    }

    public T configuration(Configuration configuration) {
        this.identityClientOptions.setConfiguration(configuration);
        return (T)this;
    }

    @Override
    public T clientOptions(ClientOptions clientOptions) {
        this.identityClientOptions.setClientOptions(clientOptions);
        return (T)this;
    }

    @Override
    public T httpLogOptions(HttpLogOptions httpLogOptions) {
        this.identityClientOptions.setHttpLogOptions(httpLogOptions);
        return (T)this;
    }

    public T retryPolicy(RetryPolicy retryPolicy) {
        this.identityClientOptions.setRetryPolicy(retryPolicy);
        return (T)this;
    }

    @Override
    public T retryOptions(RetryOptions retryOptions) {
        this.identityClientOptions.setRetryOptions(retryOptions);
        return (T)this;
    }

    @Override
    public T addPolicy(HttpPipelinePolicy httpPipelinePolicy) {
        if (httpPipelinePolicy == null) {
            throw LOGGER.logExceptionAsError(new NullPointerException("'policy' cannot be null."));
        }
        if (httpPipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.identityClientOptions.addPerCallPolicy(httpPipelinePolicy);
        } else {
            this.identityClientOptions.addPerRetryPolicy(httpPipelinePolicy);
        }
        return (T)this;
    }

    @Override
    public T pipeline(HttpPipeline httpPipeline) {
        this.identityClientOptions.setHttpPipeline(httpPipeline);
        return (T)this;
    }

    public T enableAccountIdentifierLogging() {
        this.identityClientOptions.getIdentityLogOptionsImpl().setLoggingAccountIdentifiersAllowed(true);
        return (T)this;
    }

    static {
        CredentialBuilderBaseHelper.setAccessor(new CredentialBuilderBaseHelper.CredentialBuilderBaseAccessor(){

            @Override
            public IdentityClientOptions getClientOptions(CredentialBuilderBase<?> credentialBuilderBase) {
                return credentialBuilderBase.identityClientOptions;
            }
        });
    }
}

