/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.io.InputStream;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AadCredentialBuilderBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.ClientCertificateCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.TokenCachePersistenceOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.IdentityUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;

public class ClientCertificateCredentialBuilder
extends AadCredentialBuilderBase<ClientCertificateCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(ClientCertificateCredentialBuilder.class);
    private static final String CLASS_NAME = ClientCertificateCredentialBuilder.class.getSimpleName();
    private String clientCertificatePath;
    private byte[] clientCertificateBytes;
    private String clientCertificatePassword;

    public ClientCertificateCredentialBuilder pemCertificate(String string) {
        this.clientCertificatePath = string;
        return this;
    }

    public ClientCertificateCredentialBuilder pemCertificate(InputStream inputStream) {
        this.clientCertificateBytes = IdentityUtil.convertInputStreamToByteArray(inputStream);
        return this;
    }

    @Deprecated
    public ClientCertificateCredentialBuilder pfxCertificate(String string, String string2) {
        this.clientCertificatePath = string;
        this.clientCertificatePassword = string2;
        return this;
    }

    public ClientCertificateCredentialBuilder pfxCertificate(String string) {
        this.clientCertificatePath = string;
        return this;
    }

    public ClientCertificateCredentialBuilder pfxCertificate(InputStream inputStream) {
        this.clientCertificateBytes = IdentityUtil.convertInputStreamToByteArray(inputStream);
        return this;
    }

    public ClientCertificateCredentialBuilder clientCertificatePassword(String string) {
        this.clientCertificatePassword = string;
        return this;
    }

    ClientCertificateCredentialBuilder allowUnencryptedCache() {
        this.identityClientOptions.setAllowUnencryptedCache(true);
        return this;
    }

    ClientCertificateCredentialBuilder enablePersistentCache() {
        this.identityClientOptions.enablePersistentCache();
        return this;
    }

    public ClientCertificateCredentialBuilder tokenCachePersistenceOptions(TokenCachePersistenceOptions tokenCachePersistenceOptions) {
        this.identityClientOptions.setTokenCacheOptions(tokenCachePersistenceOptions);
        return this;
    }

    public ClientCertificateCredentialBuilder sendCertificateChain(boolean bl2) {
        this.identityClientOptions.setIncludeX5c(bl2);
        return this;
    }

    public ClientCertificateCredential build() {
        ValidationUtil.validate(CLASS_NAME, LOGGER, "clientId", this.clientId, "tenantId", this.tenantId, "clientCertificate", this.clientCertificateBytes == null || this.clientCertificateBytes.length == 0 ? this.clientCertificatePath : (Object)this.clientCertificateBytes);
        if (this.clientCertificateBytes != null && this.clientCertificatePath != null) {
            throw LOGGER.logExceptionAsWarning(new IllegalArgumentException("Both certificate input stream and certificate path are provided in ClientCertificateCredentialBuilder. Only one of them should be provided."));
        }
        return new ClientCertificateCredential(this.tenantId, this.clientId, this.clientCertificatePath, this.clientCertificateBytes, this.clientCertificatePassword, this.identityClientOptions);
    }
}

