/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.net.URI;
import java.net.URISyntaxException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AadCredentialBuilderBase;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.AuthorizationCodeCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.util.ValidationUtil;

public class AuthorizationCodeCredentialBuilder
extends AadCredentialBuilderBase<AuthorizationCodeCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(AuthorizationCodeCredentialBuilder.class);
    private static final String CLASS_NAME = AuthorizationCodeCredentialBuilder.class.getSimpleName();
    private String authCode;
    private String redirectUrl;
    private String clientSecret;

    public AuthorizationCodeCredentialBuilder authorizationCode(String string) {
        this.authCode = string;
        return this;
    }

    public AuthorizationCodeCredentialBuilder redirectUrl(String string) {
        this.redirectUrl = string;
        return this;
    }

    public AuthorizationCodeCredentialBuilder clientSecret(String string) {
        this.clientSecret = string;
        return this;
    }

    public AuthorizationCodeCredential build() {
        ValidationUtil.validate(CLASS_NAME, LOGGER, "clientId", this.clientId, "authorizationCode", this.authCode, "redirectUrl", this.redirectUrl);
        try {
            return new AuthorizationCodeCredential(this.clientId, this.clientSecret, this.tenantId, this.authCode, new URI(this.redirectUrl), this.identityClientOptions);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw LOGGER.logExceptionAsError(new RuntimeException(uRISyntaxException));
        }
    }
}

