/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class AuthenticationRecord {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    @JsonProperty(value="authority")
    private String authority;
    @JsonProperty(value="homeAccountId")
    private String homeAccountId;
    @JsonProperty(value="tenantId")
    private String tenantId;
    @JsonProperty(value="username")
    private String username;
    @JsonProperty(value="clientId")
    private String clientId;

    AuthenticationRecord() {
    }

    AuthenticationRecord(IAuthenticationResult iAuthenticationResult, String string, String string2) {
        this.authority = iAuthenticationResult.account().environment();
        this.homeAccountId = iAuthenticationResult.account().homeAccountId();
        this.username = iAuthenticationResult.account().username();
        this.tenantId = string;
        this.clientId = string2;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getHomeAccountId() {
        return this.homeAccountId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getUsername() {
        return this.username;
    }

    public Mono<OutputStream> serializeAsync(OutputStream outputStream) {
        return Mono.defer(() -> {
            try {
                OBJECT_MAPPER.writeValue(outputStream, (Object)this);
            }
            catch (IOException iOException) {
                return Mono.error((Throwable)iOException);
            }
            return Mono.just((Object)outputStream);
        });
    }

    public void serialize(OutputStream outputStream) {
        this.serializeAsync(outputStream).block();
    }

    public static Mono<AuthenticationRecord> deserializeAsync(InputStream inputStream) {
        return Mono.defer(() -> {
            AuthenticationRecord authenticationRecord;
            try {
                authenticationRecord = OBJECT_MAPPER.readValue(inputStream, AuthenticationRecord.class);
            }
            catch (IOException iOException) {
                return Mono.error((Throwable)iOException);
            }
            return Mono.just((Object)authenticationRecord);
        });
    }

    public static AuthenticationRecord deserialize(InputStream inputStream) {
        return (AuthenticationRecord)AuthenticationRecord.deserializeAsync(inputStream).block();
    }
}

