/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.identity;

import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.azure.core.credential.TokenRequestContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.ManagedIdentityServiceCredential;
import macromedia.jdbc.sqlserver.externals.com.azure.identity.implementation.IdentityClient;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

class AksExchangeTokenCredential
extends ManagedIdentityServiceCredential {
    private static final ClientLogger LOGGER = new ClientLogger(AksExchangeTokenCredential.class);

    AksExchangeTokenCredential(String string, IdentityClient identityClient) {
        super(string, identityClient, "AZURE AKS TOKEN EXCHANGE");
    }

    @Override
    public Mono<AccessToken> authenticate(TokenRequestContext tokenRequestContext) {
        if (this.getClientId() == null) {
            return Mono.error((Throwable)LOGGER.logExceptionAsError(new IllegalStateException("The client id is not configured via 'AZURE_CLIENT_ID' environment variable or through the credential builder. Please ensure client id is provided to authenticate via token exchange in AKS environment.")));
        }
        return this.identityClient.authenticateWithManagedIdentityConfidentialClient(tokenRequestContext);
    }
}

