/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.AzureException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeader;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipeline;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.DefaultJsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.UrlBuilder;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.LongRunningOperationStatus;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingStrategyOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.SyncPollingStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.implementation.PollingUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.ObjectSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;

public class SyncLocationPollingStrategy<T, U>
implements SyncPollingStrategy<T, U> {
    private static final ObjectSerializer DEFAULT_SERIALIZER = new DefaultJsonSerializer();
    private static final ClientLogger LOGGER = new ClientLogger(SyncLocationPollingStrategy.class);
    private final String endpoint;
    private final HttpPipeline httpPipeline;
    private final ObjectSerializer serializer;
    private final Context context;
    private final String serviceVersion;

    public SyncLocationPollingStrategy(HttpPipeline httpPipeline) {
        this(httpPipeline, DEFAULT_SERIALIZER, Context.NONE);
    }

    public SyncLocationPollingStrategy(HttpPipeline httpPipeline, ObjectSerializer objectSerializer) {
        this(httpPipeline, objectSerializer, Context.NONE);
    }

    public SyncLocationPollingStrategy(HttpPipeline httpPipeline, ObjectSerializer objectSerializer, Context context) {
        this(httpPipeline, null, objectSerializer, context);
    }

    public SyncLocationPollingStrategy(HttpPipeline httpPipeline, String string, ObjectSerializer objectSerializer, Context context) {
        this(new PollingStrategyOptions(httpPipeline).setEndpoint(string).setSerializer(objectSerializer).setContext(context));
    }

    public SyncLocationPollingStrategy(PollingStrategyOptions pollingStrategyOptions) {
        Objects.requireNonNull(pollingStrategyOptions, "'pollingStrategyOptions' cannot be null");
        this.httpPipeline = pollingStrategyOptions.getHttpPipeline();
        this.endpoint = pollingStrategyOptions.getEndpoint();
        this.serializer = pollingStrategyOptions.getSerializer() == null ? DEFAULT_SERIALIZER : pollingStrategyOptions.getSerializer();
        this.serviceVersion = pollingStrategyOptions.getServiceVersion();
        this.context = pollingStrategyOptions.getContext() == null ? Context.NONE : pollingStrategyOptions.getContext();
    }

    @Override
    public boolean canPoll(Response<?> response) {
        return PollingUtil.locationCanPoll(response, this.endpoint, LOGGER);
    }

    @Override
    public PollResponse<T> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> typeReference) {
        HttpHeader httpHeader = response.getHeaders().get(HttpHeaderName.LOCATION);
        if (httpHeader != null) {
            pollingContext.setData("Location", PollingUtils.getAbsolutePath(httpHeader.getValue(), this.endpoint, LOGGER));
        }
        pollingContext.setData("httpMethod", response.getRequest().getHttpMethod().name());
        pollingContext.setData("requestURL", response.getRequest().getUrl().toString());
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201 || response.getStatusCode() == 202 || response.getStatusCode() == 204) {
            Duration duration = ImplUtils.getRetryAfterFromHeaders(response.getHeaders(), OffsetDateTime::now);
            return new PollResponse<T>(LongRunningOperationStatus.IN_PROGRESS, PollingUtils.convertResponseSync(response.getValue(), this.serializer, typeReference), duration);
        }
        throw LOGGER.logExceptionAsError(new AzureException(String.format("Operation failed or cancelled with status code %d, 'Location' header: %s, and response body: %s", response.getStatusCode(), httpHeader, PollingUtils.serializeResponseSync(response.getValue(), this.serializer))));
    }

    @Override
    public PollResponse<T> poll(PollingContext<T> pollingContext, TypeReference<T> typeReference) {
        String string = pollingContext.getData("Location");
        string = this.setServiceVersionQueryParam(string);
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, string);
        try (HttpResponse httpResponse = this.httpPipeline.sendSync(httpRequest, this.context);){
            HttpHeader httpHeader = httpResponse.getHeaders().get(HttpHeaderName.LOCATION);
            if (httpHeader != null) {
                pollingContext.setData("Location", httpHeader.getValue());
            }
            LongRunningOperationStatus longRunningOperationStatus = httpResponse.getStatusCode() == 202 ? LongRunningOperationStatus.IN_PROGRESS : (httpResponse.getStatusCode() >= 200 && httpResponse.getStatusCode() <= 204 ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : LongRunningOperationStatus.FAILED);
            BinaryData binaryData = httpResponse.getBodyAsBinaryData();
            pollingContext.setData("pollResponseBody", binaryData.toString());
            Duration duration = ImplUtils.getRetryAfterFromHeaders(httpResponse.getHeaders(), OffsetDateTime::now);
            PollResponse<T> pollResponse = new PollResponse<T>(longRunningOperationStatus, PollingUtils.deserializeResponseSync(binaryData, this.serializer, typeReference), duration);
            return pollResponse;
        }
    }

    @Override
    public U getResult(PollingContext<T> pollingContext, TypeReference<U> typeReference) {
        String string;
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.FAILED) {
            throw LOGGER.logExceptionAsError(new AzureException("Long-running operation failed."));
        }
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.USER_CANCELLED) {
            throw LOGGER.logExceptionAsError(new AzureException("Long-running operation cancelled."));
        }
        String string2 = pollingContext.getData("httpMethod");
        if (HttpMethod.PUT.name().equalsIgnoreCase(string2) || HttpMethod.PATCH.name().equalsIgnoreCase(string2)) {
            string = pollingContext.getData("requestURL");
        } else if (HttpMethod.POST.name().equalsIgnoreCase(string2)) {
            string = pollingContext.getData("Location");
        } else {
            throw LOGGER.logExceptionAsError(new AzureException("Cannot get final result"));
        }
        if (string == null) {
            String string3 = pollingContext.getData("pollResponseBody");
            return PollingUtils.deserializeResponseSync(BinaryData.fromString(string3), this.serializer, typeReference);
        }
        string = this.setServiceVersionQueryParam(string);
        HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, string);
        try (HttpResponse httpResponse = this.httpPipeline.sendSync(httpRequest, this.context);){
            BinaryData binaryData = httpResponse.getBodyAsBinaryData();
            U u2 = PollingUtils.deserializeResponseSync(binaryData, this.serializer, typeReference);
            return u2;
        }
    }

    private String setServiceVersionQueryParam(String string) {
        if (!CoreUtils.isNullOrEmpty(this.serviceVersion)) {
            UrlBuilder urlBuilder = UrlBuilder.parse(string);
            urlBuilder.setQueryParameter("api-version", this.serviceVersion);
            string = urlBuilder.toString();
        }
        return string;
    }
}

