/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.SyncPollingStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;

public final class SyncChainedPollingStrategy<T, U>
implements SyncPollingStrategy<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(SyncChainedPollingStrategy.class);
    private final List<SyncPollingStrategy<T, U>> pollingStrategies;
    private SyncPollingStrategy<T, U> pollableStrategy = null;

    public SyncChainedPollingStrategy(List<SyncPollingStrategy<T, U>> list) {
        Objects.requireNonNull(list, "'strategies' cannot be null.");
        if (list.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'strategies' cannot be empty."));
        }
        this.pollingStrategies = Collections.unmodifiableList(list);
    }

    @Override
    public boolean canPoll(Response<?> response) {
        for (SyncPollingStrategy<T, U> syncPollingStrategy : this.pollingStrategies) {
            if (!syncPollingStrategy.canPoll(response)) continue;
            this.pollableStrategy = syncPollingStrategy;
            return true;
        }
        return false;
    }

    @Override
    public U getResult(PollingContext<T> pollingContext, TypeReference<U> typeReference) {
        return this.pollableStrategy.getResult(pollingContext, typeReference);
    }

    @Override
    public PollResponse<T> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> typeReference) {
        return this.pollableStrategy.onInitialResponse(response, pollingContext, typeReference);
    }

    @Override
    public PollResponse<T> poll(PollingContext<T> pollingContext, TypeReference<T> typeReference) {
        return this.pollableStrategy.poll(pollingContext, typeReference);
    }

    @Override
    public T cancel(PollingContext<T> pollingContext, PollResponse<T> pollResponse) {
        return this.pollableStrategy.cancel(pollingContext, pollResponse);
    }
}

