/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling;

import java.time.Duration;
import java.time.OffsetDateTime;
import macromedia.jdbc.sqlserver.externals.com.azure.core.exception.AzureException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.Response;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.serializer.DefaultJsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.LongRunningOperationStatus;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.PollingStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.polling.implementation.PollingUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.ObjectSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class StatusCheckPollingStrategy<T, U>
implements PollingStrategy<T, U> {
    private static final ObjectSerializer DEFAULT_SERIALIZER = new DefaultJsonSerializer();
    private final ObjectSerializer serializer;

    public StatusCheckPollingStrategy() {
        this(DEFAULT_SERIALIZER);
    }

    public StatusCheckPollingStrategy(ObjectSerializer objectSerializer) {
        this.serializer = objectSerializer == null ? DEFAULT_SERIALIZER : objectSerializer;
    }

    @Override
    public Mono<Boolean> canPoll(Response<?> response) {
        return Mono.just((Object)true);
    }

    @Override
    public Mono<PollResponse<T>> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> typeReference) {
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201 || response.getStatusCode() == 202 || response.getStatusCode() == 204) {
            Duration duration = ImplUtils.getRetryAfterFromHeaders(response.getHeaders(), OffsetDateTime::now);
            return PollingUtils.convertResponse(response.getValue(), this.serializer, typeReference).map(object -> new PollResponse<Object>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, object, duration)).switchIfEmpty(Mono.fromSupplier(() -> new PollResponse<Object>(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED, null, duration)));
        }
        return Mono.error((Throwable)new AzureException("Operation failed or cancelled: " + response.getStatusCode()));
    }

    @Override
    public Mono<PollResponse<T>> poll(PollingContext<T> pollingContext, TypeReference<T> typeReference) {
        return Mono.error((Throwable)new IllegalStateException("StatusCheckPollingStrategy doesn't support polling"));
    }

    @Override
    public Mono<U> getResult(PollingContext<T> pollingContext, TypeReference<U> typeReference) {
        T t2 = pollingContext.getActivationResponse().getValue();
        return PollingUtils.convertResponse(t2, this.serializer, typeReference);
    }
}

