/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util.builder;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class ClientBuilderUtil {
    private static final ClientLogger LOGGER = new ClientLogger(ClientBuilderUtil.class);
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new RetryPolicy();

    private ClientBuilderUtil() {
    }

    public static HttpPipelinePolicy validateAndGetRetryPolicy(HttpPipelinePolicy httpPipelinePolicy, RetryOptions retryOptions) {
        return ClientBuilderUtil.validateAndGetRetryPolicy(httpPipelinePolicy, retryOptions, DEFAULT_RETRY_POLICY);
    }

    public static HttpPipelinePolicy validateAndGetRetryPolicy(HttpPipelinePolicy httpPipelinePolicy, RetryOptions retryOptions, HttpPipelinePolicy httpPipelinePolicy2) {
        Objects.requireNonNull(httpPipelinePolicy2, "'defaultPolicy' cannot be null.");
        if (httpPipelinePolicy != null && retryOptions != null) {
            throw LOGGER.logExceptionAsWarning(new IllegalStateException("'retryPolicy' and 'retryOptions' cannot both be set"));
        }
        if (httpPipelinePolicy != null) {
            return httpPipelinePolicy;
        }
        if (retryOptions != null) {
            return new RetryPolicy(retryOptions);
        }
        return httpPipelinePolicy2;
    }
}

