/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.time.Duration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpClientProvider;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.ProxyOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.HttpUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ClientOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Header;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class HttpClientOptions
extends ClientOptions {
    private static final Duration DEFAULT_CONNECTION_IDLE_TIMEOUT = Duration.ofSeconds(60L);
    private static final ClientLogger LOGGER = new ClientLogger(HttpClientOptions.class);
    private ProxyOptions proxyOptions;
    private Configuration configuration;
    private Duration connectTimeout;
    private Duration writeTimeout;
    private Duration responseTimeout;
    private Duration readTimeout;
    private Integer maximumConnectionPoolSize;
    private Duration connectionIdleTimeout;
    private Class<? extends HttpClientProvider> httpClientProvider;

    @Override
    public HttpClientOptions setApplicationId(String string) {
        super.setApplicationId(string);
        return this;
    }

    @Override
    public HttpClientOptions setHeaders(Iterable<Header> iterable) {
        super.setHeaders(iterable);
        return this;
    }

    public HttpClientOptions setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
        return this;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public HttpClientOptions setConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public HttpClientOptions setConnectTimeout(Duration duration) {
        this.connectTimeout = duration;
        return this;
    }

    public Duration getConnectTimeout() {
        return HttpUtils.getTimeout(this.connectTimeout, HttpUtils.getDefaultConnectTimeout());
    }

    public HttpClientOptions setWriteTimeout(Duration duration) {
        this.writeTimeout = duration;
        return this;
    }

    public Duration getWriteTimeout() {
        return HttpUtils.getTimeout(this.writeTimeout, HttpUtils.getDefaultWriteTimeout());
    }

    public HttpClientOptions responseTimeout(Duration duration) {
        this.responseTimeout = duration;
        return this;
    }

    public HttpClientOptions setResponseTimeout(Duration duration) {
        this.responseTimeout = duration;
        return this;
    }

    public Duration getResponseTimeout() {
        return HttpUtils.getTimeout(this.responseTimeout, HttpUtils.getDefaultResponseTimeout());
    }

    public HttpClientOptions readTimeout(Duration duration) {
        this.readTimeout = duration;
        return this;
    }

    public HttpClientOptions setReadTimeout(Duration duration) {
        this.readTimeout = duration;
        return this;
    }

    public Duration getReadTimeout() {
        return HttpUtils.getTimeout(this.readTimeout, HttpUtils.getDefaultReadTimeout());
    }

    public HttpClientOptions setMaximumConnectionPoolSize(Integer n2) {
        if (n2 != null && n2 <= 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'maximumConnectionPoolSize' cannot be less than 1."));
        }
        this.maximumConnectionPoolSize = n2;
        return this;
    }

    public Integer getMaximumConnectionPoolSize() {
        return this.maximumConnectionPoolSize;
    }

    public HttpClientOptions setConnectionIdleTimeout(Duration duration) {
        this.connectionIdleTimeout = duration;
        return this;
    }

    public Duration getConnectionIdleTimeout() {
        return HttpUtils.getTimeout(this.connectionIdleTimeout, DEFAULT_CONNECTION_IDLE_TIMEOUT);
    }

    public HttpClientOptions setHttpClientProvider(Class<? extends HttpClientProvider> clazz) {
        this.httpClientProvider = clazz;
        return this;
    }

    public Class<? extends HttpClientProvider> getHttpClientProvider() {
        return this.httpClientProvider;
    }
}

