/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;

public class Header {
    private static final String[] EMPTY_HEADER_ARRAY = new String[0];
    private final String name;
    private String value;
    private List<String> values;
    private volatile String cachedStringValue;
    private static final AtomicReferenceFieldUpdater<Header, String> CACHED_STRING_VALUE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Header.class, String.class, "cachedStringValue");

    public Header(String string, String string2) {
        Objects.requireNonNull(string, "'name' cannot be null.");
        this.name = string;
        this.value = string2;
    }

    public Header(String string, String ... stringArray) {
        Objects.requireNonNull(string, "'name' cannot be null.");
        this.name = string;
        int n2 = stringArray.length;
        if (n2 == 1) {
            this.value = stringArray[0];
        } else if (n2 != 0) {
            this.values = new ArrayList<String>(Math.max(n2 + 2, 4));
            Collections.addAll(this.values, stringArray);
        }
    }

    public Header(String string, List<String> list) {
        Objects.requireNonNull(string, "'name' cannot be null.");
        this.name = string;
        int n2 = list.size();
        if (n2 == 1) {
            this.value = list.get(0);
        } else if (n2 != 0) {
            this.values = new ArrayList<String>(Math.max(n2 + 2, 4));
            this.values.addAll(list);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (CoreUtils.isNullOrEmpty(this.values)) {
            return "";
        }
        this.checkCachedStringValue();
        return CACHED_STRING_VALUE_UPDATER.get(this);
    }

    public String[] getValues() {
        if (this.value != null) {
            return new String[]{this.value};
        }
        if (!CoreUtils.isNullOrEmpty(this.values)) {
            return this.values.toArray(new String[0]);
        }
        return EMPTY_HEADER_ARRAY;
    }

    public List<String> getValuesList() {
        if (this.value != null) {
            return Collections.singletonList(this.value);
        }
        if (!CoreUtils.isNullOrEmpty(this.values)) {
            return Collections.unmodifiableList(this.values);
        }
        return Collections.emptyList();
    }

    public void addValue(String string) {
        if (this.value == null && this.values == null) {
            this.value = string;
            return;
        }
        if (this.values == null) {
            this.values = new ArrayList<String>(4);
            this.values.add(this.value);
            this.value = null;
        }
        this.values.add(string);
        CACHED_STRING_VALUE_UPDATER.set(this, null);
    }

    public String toString() {
        if (this.value != null) {
            return this.name + ":" + this.value;
        }
        if (CoreUtils.isNullOrEmpty(this.values)) {
            return "";
        }
        this.checkCachedStringValue();
        return this.name + ":" + CACHED_STRING_VALUE_UPDATER.get(this);
    }

    private void checkCachedStringValue() {
        CACHED_STRING_VALUE_UPDATER.compareAndSet(this, null, CoreUtils.stringJoin(",", this.values));
    }
}

