/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.EnvironmentConfiguration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ConfigurationSource;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class ConfigurationBuilder {
    private static final ClientLogger LOGGER = new ClientLogger(ConfigurationBuilder.class);
    private final MutableConfigurationSource mutableSource;
    private final EnvironmentConfiguration environmentConfiguration;
    private String rootPath;
    private Configuration sharedConfiguration;

    public ConfigurationBuilder() {
        this.mutableSource = new MutableConfigurationSource();
        this.environmentConfiguration = EnvironmentConfiguration.getGlobalConfiguration();
    }

    public ConfigurationBuilder(ConfigurationSource configurationSource) {
        this.mutableSource = new MutableConfigurationSource(Objects.requireNonNull(configurationSource, "'source' cannot be null"));
        this.environmentConfiguration = EnvironmentConfiguration.getGlobalConfiguration();
    }

    public ConfigurationBuilder(ConfigurationSource configurationSource, ConfigurationSource configurationSource2, ConfigurationSource configurationSource3) {
        Objects.requireNonNull(configurationSource, "'source' cannot be null");
        Objects.requireNonNull(configurationSource2, "'systemPropertiesConfigurationSource' cannot be null");
        Objects.requireNonNull(configurationSource3, "'environmentConfigurationSource' cannot be null");
        this.mutableSource = new MutableConfigurationSource(configurationSource);
        this.environmentConfiguration = new EnvironmentConfiguration(configurationSource2, configurationSource3);
    }

    public ConfigurationBuilder putProperty(String string, String string2) {
        Objects.requireNonNull(string, "'name' cannot be null.");
        Objects.requireNonNull(string2, "'value' cannot be null.");
        this.mutableSource.put(string, string2);
        this.sharedConfiguration = null;
        return this;
    }

    public ConfigurationBuilder root(String string) {
        this.rootPath = string;
        this.sharedConfiguration = null;
        return this;
    }

    public Configuration build() {
        if (this.sharedConfiguration == null) {
            this.sharedConfiguration = new Configuration(this.mutableSource, this.environmentConfiguration, this.rootPath, null);
        }
        return this.sharedConfiguration;
    }

    public Configuration buildSection(String string) {
        Objects.requireNonNull(string, "'path' cannot be null");
        if (this.sharedConfiguration == null) {
            this.sharedConfiguration = new Configuration(this.mutableSource, this.environmentConfiguration, this.rootPath, null);
        }
        String string2 = ConfigurationBuilder.getAbsolutePath(this.rootPath, string);
        return new Configuration(this.mutableSource, this.environmentConfiguration, string2, this.sharedConfiguration);
    }

    private static String getAbsolutePath(String string, String string2) {
        if (CoreUtils.isNullOrEmpty(string)) {
            return string2;
        }
        return string + "." + string2;
    }

    private static final class MutableConfigurationSource
    implements ConfigurationSource {
        private final ConfigurationSource originalSource;
        private Map<String, String> additionalConfigurations;

        private MutableConfigurationSource() {
            this((ConfigurationSource)null);
        }

        private MutableConfigurationSource(ConfigurationSource configurationSource) {
            this.originalSource = configurationSource;
            this.additionalConfigurations = null;
        }

        MutableConfigurationSource put(String string, String string2) {
            if (this.additionalConfigurations == null) {
                this.additionalConfigurations = new HashMap<String, String>();
            }
            if (this.additionalConfigurations.containsKey(string)) {
                LOGGER.atWarning().addKeyValue("name", string).log("Property with the same name already exists, value will be overwritten.");
            }
            this.additionalConfigurations.put(string, string2);
            return this;
        }

        @Override
        public Map<String, String> getProperties(String string) {
            Map<String, String> map;
            Map<String, String> map2 = map = this.originalSource == null ? Collections.emptyMap() : this.originalSource.getProperties(string);
            if (this.additionalConfigurations == null) {
                return map;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(map);
            for (Map.Entry<String, String> entry : this.additionalConfigurations.entrySet()) {
                if (hashMap.containsKey(entry.getKey())) {
                    LOGGER.atWarning().addKeyValue("name", entry.getKey()).log("Property with the same name already exists, value will be overwritten.");
                }
                if (!MutableConfigurationSource.hasPrefix(entry.getKey(), string)) continue;
                hashMap.put(entry.getKey(), entry.getValue());
            }
            return hashMap;
        }

        private static boolean hasPrefix(String string, String string2) {
            return string2 == null || string.startsWith(string2) && string.length() > string2.length() && string.charAt(string2.length()) == '.';
        }
    }
}

