/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.ByteArrayContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.ByteBufferContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.FileContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.FluxByteBufferContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.InputStreamContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.ListByteBufferContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.SerializableContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.StringContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.JsonSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.JsonSerializerProviders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.ObjectSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class BinaryData {
    private static final ClientLogger LOGGER = new ClientLogger(BinaryData.class);
    static final JsonSerializer SERIALIZER = JsonSerializerProviders.createInstance(true);
    static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private final BinaryDataContent content;

    BinaryData(BinaryDataContent binaryDataContent) {
        this.content = Objects.requireNonNull(binaryDataContent, "'content' cannot be null.");
    }

    public static BinaryData fromStream(InputStream inputStream) {
        return BinaryData.fromStream(inputStream, null);
    }

    public static BinaryData fromStream(InputStream inputStream, Long l2) {
        return new BinaryData(new InputStreamContent(inputStream, l2));
    }

    public static Mono<BinaryData> fromStreamAsync(InputStream inputStream) {
        return BinaryData.fromStreamAsync(inputStream, null);
    }

    public static Mono<BinaryData> fromStreamAsync(InputStream inputStream, Long l2) {
        return Mono.fromCallable(() -> BinaryData.fromStream(inputStream, l2));
    }

    public static Mono<BinaryData> fromFlux(Flux<ByteBuffer> flux) {
        return BinaryData.fromFlux(flux, null);
    }

    public static Mono<BinaryData> fromFlux(Flux<ByteBuffer> flux, Long l2) {
        return BinaryData.fromFlux(flux, l2, true);
    }

    public static Mono<BinaryData> fromFlux(Flux<ByteBuffer> flux, Long l2, boolean bl2) {
        if (flux == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'data' cannot be null."));
        }
        if (l2 != null && l2 < 0L) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new IllegalArgumentException("'length' cannot be less than 0."));
        }
        if (!bl2) {
            return Mono.just((Object)new BinaryData(new FluxByteBufferContent(flux, l2)));
        }
        long[] lArray = new long[]{0L};
        return flux.map(byteBuffer -> {
            int n2 = byteBuffer.remaining();
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(n2);
            lArray[0] = lArray[0] + (long)n2;
            byteBuffer2.put((ByteBuffer)byteBuffer);
            byteBuffer2.flip();
            return byteBuffer2;
        }).collect(LinkedList::new, LinkedList::add).map(linkedList -> new BinaryData(new FluxByteBufferContent((Flux<ByteBuffer>)Flux.fromIterable((Iterable)linkedList).map(ByteBuffer::duplicate), l2 != null ? l2 : lArray[0], true)));
    }

    public static BinaryData fromString(String string) {
        return new BinaryData(new StringContent(string));
    }

    public static BinaryData fromBytes(byte[] byArray) {
        return new BinaryData(new ByteArrayContent(byArray));
    }

    public static BinaryData fromByteBuffer(ByteBuffer byteBuffer) {
        return new BinaryData(new ByteBufferContent(byteBuffer));
    }

    public static BinaryData fromListByteBuffer(List<ByteBuffer> list) {
        return new BinaryData(new ListByteBufferContent(list));
    }

    public static BinaryData fromObject(Object object) {
        return BinaryData.fromObject(object, SERIALIZER);
    }

    public static Mono<BinaryData> fromObjectAsync(Object object) {
        return BinaryData.fromObjectAsync(object, SERIALIZER);
    }

    public static BinaryData fromObject(Object object, ObjectSerializer objectSerializer) {
        return new BinaryData(new SerializableContent(object, objectSerializer));
    }

    public static Mono<BinaryData> fromObjectAsync(Object object, ObjectSerializer objectSerializer) {
        return Mono.fromCallable(() -> BinaryData.fromObject(object, objectSerializer));
    }

    public static BinaryData fromFile(Path path) {
        return BinaryData.fromFile(path, 8192);
    }

    public static BinaryData fromFile(Path path, int n2) {
        return new BinaryData(new FileContent(path, n2, null, null));
    }

    public static BinaryData fromFile(Path path, Long l2, Long l3) {
        return new BinaryData(new FileContent(path, 8192, l2, l3));
    }

    public static BinaryData fromFile(Path path, Long l2, Long l3, int n2) {
        return new BinaryData(new FileContent(path, n2, l2, l3));
    }

    public byte[] toBytes() {
        return this.content.toBytes();
    }

    public String toString() {
        return this.content.toString();
    }

    public <T> T toObject(Class<T> clazz) {
        return this.toObject(TypeReference.createInstance(clazz), (ObjectSerializer)SERIALIZER);
    }

    public <T> T toObject(TypeReference<T> typeReference) {
        return this.toObject(typeReference, (ObjectSerializer)SERIALIZER);
    }

    public <T> T toObject(Class<T> clazz, ObjectSerializer objectSerializer) {
        return this.toObject(TypeReference.createInstance(clazz), objectSerializer);
    }

    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer objectSerializer) {
        Objects.requireNonNull(typeReference, "'typeReference' cannot be null.");
        Objects.requireNonNull(objectSerializer, "'serializer' cannot be null.");
        return this.content.toObject(typeReference, objectSerializer);
    }

    public <T> Mono<T> toObjectAsync(Class<T> clazz) {
        return this.toObjectAsync(TypeReference.createInstance(clazz), (ObjectSerializer)SERIALIZER);
    }

    public <T> Mono<T> toObjectAsync(TypeReference<T> typeReference) {
        return this.toObjectAsync(typeReference, (ObjectSerializer)SERIALIZER);
    }

    public <T> Mono<T> toObjectAsync(Class<T> clazz, ObjectSerializer objectSerializer) {
        return this.toObjectAsync(TypeReference.createInstance(clazz), objectSerializer);
    }

    public <T> Mono<T> toObjectAsync(TypeReference<T> typeReference, ObjectSerializer objectSerializer) {
        return Mono.fromCallable(() -> this.toObject(typeReference, objectSerializer));
    }

    public InputStream toStream() {
        return this.content.toStream();
    }

    public ByteBuffer toByteBuffer() {
        return this.content.toByteBuffer();
    }

    public Flux<ByteBuffer> toFluxByteBuffer() {
        return this.content.toFluxByteBuffer();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        Objects.requireNonNull(outputStream, "'outputStream' cannot be null.");
        this.content.writeTo(outputStream);
    }

    public void writeTo(WritableByteChannel writableByteChannel) throws IOException {
        Objects.requireNonNull(writableByteChannel, "'channel' cannot be null.");
        this.content.writeTo(writableByteChannel);
    }

    public Mono<Void> writeTo(AsynchronousByteChannel asynchronousByteChannel) {
        return this.content.writeTo(asynchronousByteChannel);
    }

    public Long getLength() {
        return this.content.getLength();
    }

    public boolean isReplayable() {
        return this.content.isReplayable();
    }

    public BinaryData toReplayableBinaryData() {
        if (this.isReplayable()) {
            return this;
        }
        return new BinaryData(this.content.toReplayableContent());
    }

    public Mono<BinaryData> toReplayableBinaryDataAsync() {
        if (this.isReplayable()) {
            return Mono.just((Object)this);
        }
        return this.content.toReplayableContentAsync().map(BinaryData::new);
    }

    static {
        BinaryDataHelper.setAccessor(new BinaryDataHelper.BinaryDataAccessor(){

            @Override
            public BinaryData createBinaryData(BinaryDataContent binaryDataContent) {
                return new BinaryData(binaryDataContent);
            }

            @Override
            public BinaryDataContent getContent(BinaryData binaryData) {
                return binaryData.content;
            }
        });
    }
}

