/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoArray;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoBoundingBox;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoLinearRing;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObject;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObjectType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPolygon;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPosition;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;

public final class GeoPolygonCollection
extends GeoObject {
    private final List<GeoPolygon> polygons;

    public GeoPolygonCollection(List<GeoPolygon> list) {
        this(list, null, null);
    }

    public GeoPolygonCollection(List<GeoPolygon> list, GeoBoundingBox geoBoundingBox, Map<String, Object> map) {
        super(geoBoundingBox, map);
        Objects.requireNonNull(list, "'polygons' cannot be null.");
        this.polygons = Collections.unmodifiableList(new ArrayList<GeoPolygon>(list));
    }

    public List<GeoPolygon> getPolygons() {
        return this.polygons;
    }

    GeoArray<GeoArray<GeoArray<GeoPosition>>> getCoordinates() {
        return new GeoArray<GeoArray<GeoArray<GeoPosition>>>(this);
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.MULTI_POLYGON;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.polygons, super.hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof GeoPolygonCollection)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GeoPolygonCollection geoPolygonCollection = (GeoPolygonCollection)object;
        return super.equals(object) && Objects.equals(this.polygons, geoPolygonCollection.polygons);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter2) throws IOException {
        jsonWriter2.writeStartObject().writeStringField("type", GeoObjectType.MULTI_POLYGON.toString()).writeArrayField("coordinates", this.polygons, (jsonWriter, geoPolygon) -> jsonWriter.writeArray(geoPolygon.getRings(), JsonWriter::writeJson)).writeJsonField("bbox", this.getBoundingBox());
        return this.writeCustomProperties(jsonWriter2).writeEndObject();
    }

    public static GeoPolygonCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(jsonReader2 -> {
            ArrayList<GeoPolygon> arrayList = null;
            GeoBoundingBox geoBoundingBox = null;
            LinkedHashMap<String, Object> linkedHashMap = null;
            while (jsonReader2.nextToken() != JsonToken.END_OBJECT) {
                Object object;
                String string = jsonReader2.getFieldName();
                jsonReader2.nextToken();
                if ("type".equals(string)) {
                    object = jsonReader2.getString();
                    if (GeoObjectType.MULTI_POLYGON.toString().equals(object)) continue;
                    throw new IllegalStateException("'type' was expected to be non-null and equal to 'MultiPolygon'. The found 'type' was '" + (String)object + "'.");
                }
                if ("coordinates".equals(string)) {
                    object = jsonReader2.readArray(jsonReader -> jsonReader.readArray(GeoLinearRing::fromJson));
                    arrayList = new ArrayList<GeoPolygon>(object.size());
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        List list = (List)iterator.next();
                        arrayList.add(new GeoPolygon(list));
                    }
                    continue;
                }
                if ("bbox".equals(string)) {
                    geoBoundingBox = GeoBoundingBox.fromJson(jsonReader2);
                    continue;
                }
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap<String, Object>();
                }
                linkedHashMap.put(string, jsonReader2.readUntyped());
            }
            return new GeoPolygonCollection(arrayList, geoBoundingBox, linkedHashMap);
        });
    }
}

