/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.GeoObjectHelper;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoBoundingBox;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoLineString;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoLineStringCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoObjectType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPoint;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPointCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPolygon;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPolygonCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonSubTypes;

@JsonSubTypes(value={@JsonSubTypes.Type(name="Point", value=GeoPoint.class), @JsonSubTypes.Type(name="LineString", value=GeoLineString.class), @JsonSubTypes.Type(name="Polygon", value=GeoPolygon.class), @JsonSubTypes.Type(name="MultiPoint", value=GeoPointCollection.class), @JsonSubTypes.Type(name="MultiLineString", value=GeoLineStringCollection.class), @JsonSubTypes.Type(name="MultiPolygon", value=GeoPolygonCollection.class), @JsonSubTypes.Type(name="GeometryCollection", value=GeoCollection.class)})
public abstract class GeoObject
implements JsonSerializable<GeoObject> {
    private final GeoBoundingBox boundingBox;
    private final Map<String, Object> customProperties;

    protected GeoObject(GeoBoundingBox geoBoundingBox, Map<String, Object> map) {
        this.boundingBox = geoBoundingBox;
        this.customProperties = map == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(map));
    }

    @JsonProperty(value="type")
    public abstract GeoObjectType getType();

    public final GeoBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public final Map<String, Object> getCustomProperties() {
        return this.customProperties;
    }

    public int hashCode() {
        return Objects.hash(this.boundingBox, this.customProperties);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GeoObject)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GeoObject geoObject = (GeoObject)object;
        return Objects.equals(this.boundingBox, geoObject.boundingBox) && Objects.equals(this.customProperties, geoObject.customProperties);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject().writeJsonField("bbox", this.getBoundingBox());
        Map<String, Object> map = this.getCustomProperties();
        if (!CoreUtils.isNullOrEmpty(map)) {
            jsonWriter.writeMap(map, JsonWriter::writeUntyped);
        }
        return jsonWriter.writeEndObject();
    }

    public static GeoObject fromJson(JsonReader jsonReader2) throws IOException {
        return jsonReader2.readObject(jsonReader -> {
            String string = null;
            JsonReader jsonReader2 = jsonReader.bufferObject();
            jsonReader2.nextToken();
            while (jsonReader2.nextToken() != JsonToken.END_OBJECT) {
                String string2 = jsonReader2.getFieldName();
                jsonReader2.nextToken();
                if ("type".equals(string2)) {
                    string = jsonReader2.getString();
                    break;
                }
                jsonReader2.skipChildren();
            }
            if (string != null) {
                jsonReader2 = jsonReader2.reset();
            }
            if ("Point".equals(string)) {
                return GeoPoint.fromJson(jsonReader2);
            }
            if ("MultiPoint".equals(string)) {
                return GeoPointCollection.fromJson(jsonReader2);
            }
            if ("Polygon".equals(string)) {
                return GeoPolygon.fromJson(jsonReader2);
            }
            if ("MultiPolygon".equals(string)) {
                return GeoPolygonCollection.fromJson(jsonReader2);
            }
            if ("LineString".equals(string)) {
                return GeoLineString.fromJson(jsonReader2);
            }
            if ("MultiLineString".equals(string)) {
                return GeoLineStringCollection.fromJson(jsonReader2);
            }
            if ("GeometryCollection".equals(string)) {
                return GeoCollection.fromJson(jsonReader2);
            }
            throw new IllegalStateException("Discriminator field 'type' didn't match one of the expected values 'Point', 'MultiPoint', 'Polygon', 'MultiPolygon', 'LineString', 'MultiLineString', or 'GeometryCollection'. It was: '" + string + "'.");
        });
    }

    JsonWriter writeCustomProperties(JsonWriter jsonWriter) throws IOException {
        if (!CoreUtils.isNullOrEmpty(this.customProperties)) {
            for (Map.Entry<String, Object> entry : this.customProperties.entrySet()) {
                jsonWriter.writeUntypedField(String.valueOf(entry.getKey()), entry.getValue());
            }
        }
        return jsonWriter;
    }

    static {
        GeoObjectHelper.setAccessor(GeoObject::getCustomProperties);
    }
}

