/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.models;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoArray;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.GeoPosition;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonWriter;

public final class GeoLinearRing
implements JsonSerializable<GeoLinearRing> {
    private static final ClientLogger LOGGER = new ClientLogger(GeoLinearRing.class);
    private final GeoArray<GeoPosition> coordinates;

    public GeoLinearRing(List<GeoPosition> list) {
        Objects.requireNonNull(list, "'coordinates' cannot be null.");
        int n2 = list.size();
        if (n2 < 4) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("A linear ring requires at least 4 coordinates."));
        }
        if (!Objects.equals(list.get(0), list.get(n2 - 1))) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("The first and last coordinates of a linear ring must be equivalent."));
        }
        this.coordinates = new GeoArray(new ArrayList<GeoPosition>(list));
    }

    public List<GeoPosition> getCoordinates() {
        return this.coordinates;
    }

    public int hashCode() {
        return this.coordinates.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof GeoLinearRing)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        GeoLinearRing geoLinearRing = (GeoLinearRing)object;
        return Objects.equals(this.coordinates, geoLinearRing.coordinates);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeArray(this.getCoordinates(), JsonWriter::writeJson);
    }

    public static GeoLinearRing fromJson(JsonReader jsonReader) throws IOException {
        List<GeoPosition> list = jsonReader.readArray(GeoPosition::fromJson);
        if (list == null) {
            return null;
        }
        return new GeoLinearRing(list);
    }
}

