/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;

public final class SliceInputStream
extends InputStream {
    private static final ClientLogger LOGGER = new ClientLogger(SliceInputStream.class);
    private final InputStream innerStream;
    private final long startOfSlice;
    private final long endOfSlice;
    private long innerPosition = 0L;
    private long mark = -1L;

    public SliceInputStream(InputStream inputStream, long l2, long l3) {
        this.innerStream = Objects.requireNonNull(inputStream, "'inputStream' cannot be null");
        if (l2 < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'position' cannot be negative"));
        }
        if (l3 < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'count' cannot be negative"));
        }
        this.startOfSlice = l2;
        this.endOfSlice = l2 + l3;
    }

    @Override
    public synchronized long skip(long l2) throws IOException {
        if (this.ensureInWindow() < 0L) {
            return 0L;
        }
        if (this.innerPosition > this.endOfSlice) {
            return 0L;
        }
        long l3 = Math.min(l2, Math.max(0L, this.endOfSlice - this.innerPosition));
        long l4 = this.innerStream.skip(l3);
        this.innerPosition += l4;
        return l4;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.ensureInWindow() < 0L) {
            return -1;
        }
        int n2 = this.innerStream.read();
        if (n2 >= 0) {
            ++this.innerPosition;
        }
        return n2;
    }

    @Override
    public synchronized int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.ensureInWindow() < 0L) {
            return -1;
        }
        int n4 = this.innerStream.read(byArray, n2, n3);
        if (n4 > 0) {
            this.innerPosition += (long)n4;
            if (this.innerPosition > this.endOfSlice) {
                return (int)((long)n4 - (this.innerPosition - this.endOfSlice));
            }
        }
        return n4;
    }

    private long ensureInWindow() throws IOException {
        if (this.startOfSlice == this.endOfSlice) {
            return -1L;
        }
        if (this.innerPosition >= this.endOfSlice) {
            return -1L;
        }
        long l2 = 0L;
        while (this.innerPosition < this.startOfSlice) {
            long l3 = this.innerStream.skip(this.startOfSlice - this.innerPosition);
            l2 += l3;
            this.innerPosition += l3;
            if (l3 != 0L) continue;
            int n2 = this.innerStream.read();
            if (n2 < 0) {
                return -1L;
            }
            ++l2;
            ++this.innerPosition;
        }
        return l2;
    }

    @Override
    public void close() throws IOException {
        this.innerStream.close();
    }

    @Override
    public boolean markSupported() {
        return this.innerStream.markSupported();
    }

    @Override
    public synchronized void mark(int n2) {
        try {
            this.ensureInWindow();
        }
        catch (IOException iOException) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(iOException));
        }
        this.innerStream.mark(n2);
        this.mark = this.innerPosition;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.innerStream.reset();
        this.innerPosition = this.mark;
    }
}

