/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util;

import java.lang.ref.ReferenceQueue;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectiveInvoker;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.CleanableReference;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ReferenceManager;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;

public final class ReferenceManagerImpl
implements ReferenceManager {
    private static final ClientLogger LOGGER = new ClientLogger(ReferenceManagerImpl.class);
    private static final String BASE_THREAD_NAME = "azure-sdk-referencemanager";
    private static final Object CLEANER;
    private static final ReflectiveInvoker CLEANER_REGISTER;
    private final CleanableReference<?> cleanableReferenceList;
    private final ReferenceQueue<Object> queue;

    public ReferenceManagerImpl() {
        if (CLEANER == null) {
            this.queue = new ReferenceQueue();
            this.cleanableReferenceList = new CleanableReference();
            Thread thread = new Thread(this::clearReferenceQueue, BASE_THREAD_NAME);
            new CleanableReference<ReferenceManagerImpl>(this, () -> {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    LOGGER.log(LogLevel.WARNING, () -> "Failed to shutdown ReferenceManager thread.", interruptedException);
                }
            }, this);
            thread.setDaemon(true);
            thread.start();
        } else {
            this.queue = null;
            this.cleanableReferenceList = null;
        }
    }

    @Override
    public void register(Object object, Runnable runnable) {
        Objects.requireNonNull(object, "'object' cannot be null.");
        Objects.requireNonNull(runnable, "'cleanupAction' cannot be null.");
        if (CLEANER == null) {
            new CleanableReference<Object>(object, runnable, this);
        } else {
            try {
                CLEANER_REGISTER.invokeWithArguments(CLEANER, object, runnable);
            }
            catch (Exception exception) {
                if (exception instanceof RuntimeException) {
                    throw LOGGER.logExceptionAsError((RuntimeException)exception);
                }
                throw LOGGER.logExceptionAsError(new RuntimeException(exception));
            }
        }
    }

    void clearReferenceQueue() {
        while (this.cleanableReferenceList.hasRemaining()) {
            CleanableReference cleanableReference = null;
            try {
                cleanableReference = (CleanableReference)this.queue.remove(30000L);
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(LogLevel.VERBOSE, () -> "ReferenceManager Thread interrupted while waiting for a reference to clean.", interruptedException);
            }
            try {
                if (cleanableReference == null) continue;
                cleanableReference.clean();
            }
            catch (Exception exception) {
                LOGGER.log(LogLevel.INFORMATIONAL, () -> "Cleaning a reference threw an exception.", exception);
            }
        }
    }

    static boolean isCleanerUsed() {
        return CLEANER != null;
    }

    ReferenceQueue<Object> getQueue() {
        return this.queue;
    }

    CleanableReference<?> getCleanableReferenceList() {
        return this.cleanableReferenceList;
    }

    static {
        Object object = null;
        ReflectiveInvoker reflectiveInvoker = null;
        try {
            Class<?> clazz = Class.forName("java.lang.ref.Cleaner");
            object = clazz.getDeclaredMethod("create", ThreadFactory.class).invoke(null, runnable -> new Thread(runnable, BASE_THREAD_NAME));
            reflectiveInvoker = ReflectionUtils.getMethodInvoker(clazz, clazz.getDeclaredMethod("register", Object.class, Runnable.class), false);
        }
        catch (Exception exception) {
            LOGGER.log(LogLevel.VERBOSE, () -> "Unable to use java.lang.ref.Cleaner to manage references.", exception);
        }
        CLEANER = object;
        CLEANER_REGISTER = reflectiveInvoker;
    }
}

