/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataContent;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.BinaryDataContentType;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.util.SliceInputStream;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.FluxUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.ObjectSerializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.TypeReference;
import macromedia.jdbc.sqlserver.externals.reactor.core.Exceptions;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Flux;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class FileContent
extends BinaryDataContent {
    private static final ClientLogger LOGGER = new ClientLogger(FileContent.class);
    private final Path file;
    private final int chunkSize;
    private final long position;
    private final long length;
    private volatile byte[] bytes;
    private static final AtomicReferenceFieldUpdater<FileContent, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(FileContent.class, byte[].class, "bytes");

    public FileContent(Path path, int n2, Long l2, Long l3) {
        this(FileContent.validateFile(path), FileContent.validateChunkSize(n2), FileContent.validatePosition(l2), FileContent.validateLength(l3, path.toFile().length(), FileContent.validatePosition(l2)));
    }

    FileContent(Path path, int n2, long l2, long l3) {
        this.file = path;
        this.chunkSize = n2;
        this.position = l2;
        this.length = l3;
    }

    private static Path validateFile(Path path) {
        Objects.requireNonNull(path, "'file' cannot be null.");
        if (!path.toFile().exists()) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(new FileNotFoundException("File does not exist " + path)));
        }
        return path;
    }

    private static int validateChunkSize(int n2) {
        if (n2 <= 0) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'chunkSize' cannot be less than or equal to 0."));
        }
        return n2;
    }

    private static long validatePosition(Long l2) {
        if (l2 != null && l2 < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'position' cannot be negative."));
        }
        return l2 != null ? l2 : 0L;
    }

    private static long validateLength(Long l2, long l3, long l4) {
        if (l2 != null && l2 < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'length' cannot be negative."));
        }
        long l5 = l3 - l4;
        return l2 == null ? l5 : Math.min(l2, l5);
    }

    @Override
    public Long getLength() {
        return this.length;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        return BYTES_UPDATER.updateAndGet(this, byArray -> byArray == null ? this.getBytes() : byArray);
    }

    @Override
    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer objectSerializer) {
        return objectSerializer.deserialize(this.toStream(), typeReference);
    }

    @Override
    public InputStream toStream() {
        try {
            return new SliceInputStream(new BufferedInputStream(this.getFileInputStream(), this.chunkSize), this.position, this.length);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException("File not found " + this.file, fileNotFoundException));
        }
    }

    protected FileInputStream getFileInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file.toFile());
    }

    @Override
    public ByteBuffer toByteBuffer() {
        if (this.length > Integer.MAX_VALUE) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("The content length is too large for a byte array. Content length is: " + this.length));
        }
        return this.toByteBufferInternal();
    }

    protected ByteBuffer toByteBufferInternal() {
        MappedByteBuffer mappedByteBuffer;
        block8: {
            FileChannel fileChannel = FileChannel.open(this.file, new OpenOption[0]);
            try {
                mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, this.position, this.length);
                if (fileChannel == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileChannel != null) {
                        try {
                            fileChannel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw LOGGER.logExceptionAsError(new UncheckedIOException(iOException));
                }
            }
            fileChannel.close();
        }
        return mappedByteBuffer;
    }

    @Override
    public Flux<ByteBuffer> toFluxByteBuffer() {
        return Flux.using(this::openAsynchronousFileChannel, asynchronousFileChannel -> FluxUtil.readFile(asynchronousFileChannel, this.chunkSize, this.position, this.length), asynchronousFileChannel -> {
            try {
                asynchronousFileChannel.close();
            }
            catch (IOException iOException) {
                throw LOGGER.logExceptionAsError(Exceptions.propagate((Throwable)iOException));
            }
        });
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        this.writeTo(Channels.newChannel(outputStream));
    }

    @Override
    public void writeTo(WritableByteChannel writableByteChannel) throws IOException {
        try (FileChannel fileChannel = FileChannel.open(this.file, new OpenOption[0]);){
            long l2;
            for (long i2 = 0L; i2 < this.length; i2 += l2) {
                l2 = fileChannel.transferTo(this.position + i2, this.length - i2, writableByteChannel);
                if (l2 >= 0L) continue;
                return;
            }
        }
    }

    @Override
    public Mono<Void> writeTo(AsynchronousByteChannel asynchronousByteChannel) {
        if (asynchronousByteChannel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'channel' cannot be null."));
        }
        return FluxUtil.writeToAsynchronousByteChannel(this.toFluxByteBuffer(), asynchronousByteChannel);
    }

    protected AsynchronousFileChannel openAsynchronousFileChannel() throws IOException {
        return AsynchronousFileChannel.open(this.file, StandardOpenOption.READ);
    }

    public Path getFile() {
        return this.file;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    @Override
    public boolean isReplayable() {
        return true;
    }

    @Override
    public BinaryDataContent toReplayableContent() {
        return this;
    }

    @Override
    public Mono<BinaryDataContent> toReplayableContentAsync() {
        return Mono.just((Object)this);
    }

    @Override
    public BinaryDataContentType getContentType() {
        return BinaryDataContentType.BINARY;
    }

    private byte[] getBytes() {
        byte[] byArray;
        block11: {
            if (this.length > 0x7FFFFFF7L) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("The content length is too large for a byte array. Content length is: " + this.length));
            }
            InputStream inputStream = this.toStream();
            try {
                int n2;
                byte[] byArray2 = new byte[(int)this.length];
                int n3 = byArray2.length;
                int n4 = 0;
                do {
                    if ((n2 = inputStream.read(byArray2, n4, n3)) >= 0) {
                        n4 += n2;
                        continue;
                    }
                    throw LOGGER.logExceptionAsError(new IllegalStateException("Premature EOF. File was modified concurrently."));
                } while ((n3 -= n2) > 0);
                byArray = byArray2;
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw LOGGER.logExceptionAsError(new UncheckedIOException(iOException));
                }
            }
            inputStream.close();
        }
        return byArray;
    }
}

