/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.lang.reflect.Array;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectiveInvoker;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.JacksonDatabind212;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.JacksonVersion;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.ObjectMapperFactory;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.MapperBuilder;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.cfg.PackageVersion;

public final class XmlMapperFactory {
    private static final ClientLogger LOGGER = new ClientLogger(XmlMapperFactory.class);
    private static final String XML_MAPPER = "macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.XmlMapper";
    private static final String XML_MAPPER_BUILDER = "macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.XmlMapper$Builder";
    private static final String FROM_XML_PARSER = "macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser$Feature";
    private static final String TO_XML_GENERATOR = "macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator$Feature";
    private final ReflectiveInvoker createXmlMapperBuilder;
    private final ReflectiveInvoker defaultUseWrapper;
    private final ReflectiveInvoker enableWriteXmlDeclaration;
    private final Object writeXmlDeclaration;
    private final ReflectiveInvoker enableEmptyElementAsNull;
    private final Object emptyElementAsNull;
    final boolean useJackson212;
    private boolean jackson212IsSafe = true;
    public static final XmlMapperFactory INSTANCE = new XmlMapperFactory();

    private XmlMapperFactory() {
        Object object;
        ReflectiveInvoker reflectiveInvoker;
        Object object2;
        ReflectiveInvoker reflectiveInvoker2;
        ReflectiveInvoker reflectiveInvoker3;
        ReflectiveInvoker reflectiveInvoker4;
        ClassLoader classLoader = XmlMapperFactory.class.getClassLoader();
        try {
            Class<?> clazz = Class.forName(XML_MAPPER, true, classLoader);
            Class<?> clazz2 = Class.forName(XML_MAPPER_BUILDER, true, classLoader);
            Class<?> clazz3 = Class.forName(FROM_XML_PARSER, true, classLoader);
            Class<?> clazz4 = Class.forName(TO_XML_GENERATOR, true, classLoader);
            reflectiveInvoker4 = ReflectionUtils.getMethodInvoker(clazz, clazz.getDeclaredMethod("builder", new Class[0]), false);
            reflectiveInvoker3 = ReflectionUtils.getMethodInvoker(clazz2, clazz2.getDeclaredMethod("defaultUseWrapper", Boolean.TYPE), false);
            reflectiveInvoker2 = ReflectionUtils.getMethodInvoker(clazz2, clazz2.getDeclaredMethod("enable", Array.newInstance(clazz4, 0).getClass()), false);
            object2 = clazz4.getDeclaredField("WRITE_XML_DECLARATION").get(null);
            reflectiveInvoker = ReflectionUtils.getMethodInvoker(clazz2, clazz2.getDeclaredMethod("enable", Array.newInstance(clazz3, 0).getClass()), false);
            object = clazz3.getDeclaredField("EMPTY_ELEMENT_AS_NULL").get(null);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Error && !(throwable instanceof LinkageError)) {
                throw LOGGER.logThrowableAsError((Error)throwable);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException("Failed to retrieve invoker used to create XmlMapper. XML serialization won't be supported until 'com.fasterxml.jackson.dataformat:jackson-dataformat-xml' is added to the classpath or updated to a supported version. " + JacksonVersion.getHelpInfo(), throwable));
        }
        this.createXmlMapperBuilder = reflectiveInvoker4;
        this.defaultUseWrapper = reflectiveInvoker3;
        this.enableWriteXmlDeclaration = reflectiveInvoker2;
        this.writeXmlDeclaration = object2;
        this.enableEmptyElementAsNull = reflectiveInvoker;
        this.emptyElementAsNull = object;
        this.useJackson212 = PackageVersion.VERSION.getMinorVersion() >= 12;
    }

    public ObjectMapper createXmlMapper() {
        Object m2;
        try {
            MapperBuilder mapperBuilder = ObjectMapperFactory.initializeMapperBuilder((MapperBuilder)this.createXmlMapperBuilder.invokeStatic(new Object[0]));
            this.defaultUseWrapper.invokeWithArguments(mapperBuilder, false);
            this.enableWriteXmlDeclaration.invokeWithArguments(mapperBuilder, this.writeXmlDeclaration);
            this.enableEmptyElementAsNull.invokeWithArguments(mapperBuilder, this.emptyElementAsNull);
            m2 = mapperBuilder.build();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)exception);
            }
            throw LOGGER.logExceptionAsError(new IllegalStateException("Unable to create XmlMapper instance.", exception));
        }
        if (this.useJackson212 && this.jackson212IsSafe) {
            try {
                return JacksonDatabind212.mutateXmlCoercions(m2);
            }
            catch (Throwable throwable) {
                if (throwable instanceof LinkageError) {
                    this.jackson212IsSafe = false;
                    LOGGER.log(LogLevel.VERBOSE, JacksonVersion::getHelpInfo, throwable);
                }
                throw throwable;
            }
        }
        return m2;
    }
}

