/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.azure.core.models.ResponseError;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanDescription;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.module.SimpleModule;

final class ResponseErrorDeserializer
extends StdDeserializer<Object> {
    private static final long serialVersionUID = 1L;
    private static final Pattern CODE_PATTERN = Pattern.compile("\"code\"", 2);
    private static final Pattern MESSAGE_PATTERN = Pattern.compile("\"message\"", 2);
    private static final Pattern TARGET_PATTERN = Pattern.compile("\"target\"", 2);
    private static final Pattern DETAILS_PATTERN = Pattern.compile("\"details\"", 2);
    public static final String ERROR_PROPERTY_KEY = "error";
    private final ObjectMapper mapper;

    private ResponseErrorDeserializer(Class<?> clazz, ObjectMapper objectMapper) {
        super(clazz);
        this.mapper = objectMapper;
    }

    public static SimpleModule getModule(final ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.setDeserializerModifier(new BeanDeserializerModifier(){

            @Override
            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig deserializationConfig, BeanDescription beanDescription, JsonDeserializer<?> jsonDeserializer) {
                if (ResponseError.class.isAssignableFrom(beanDescription.getBeanClass())) {
                    return new ResponseErrorDeserializer(beanDescription.getBeanClass(), objectMapper);
                }
                return jsonDeserializer;
            }
        });
        return simpleModule;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        jsonParser.setCodec(this.mapper);
        JsonNode jsonNode = (JsonNode)jsonParser.readValueAsTree();
        if (jsonNode == null) {
            return null;
        }
        if (jsonNode.get(ERROR_PROPERTY_KEY) != null) {
            jsonNode = jsonNode.get(ERROR_PROPERTY_KEY);
        }
        String string = jsonNode.toString();
        string = CODE_PATTERN.matcher(string).replaceFirst("\"code\"");
        string = MESSAGE_PATTERN.matcher(string).replaceFirst("\"message\"");
        string = TARGET_PATTERN.matcher(string).replaceFirst("\"target\"");
        string = DETAILS_PATTERN.matcher(string).replaceFirst("\"details\"");
        JsonParser jsonParser2 = new JsonFactory().createParser(string);
        jsonParser2.setCodec(this.mapper);
        return jsonParser2.readValueAs(this.handledType());
    }
}

