/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.HeaderCollection;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeader;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionSerializable;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectionUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ReflectiveInvoker;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.TypeUtil;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.HeaderCollectionHandler;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.JacksonVersion;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.JsonSerializableDeserializer;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.MemberNameConverterImpl;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.ObjectMapperFactory;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LogLevel;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;

public final class ObjectMapperShim {
    private static final ClientLogger LOGGER = new ClientLogger(ObjectMapperShim.class);
    private static final int CACHE_SIZE_LIMIT = 10000;
    private static final Map<Type, JavaType> TYPE_TO_JAVA_TYPE_CACHE = new ConcurrentHashMap<Type, JavaType>();
    private static final Map<Type, ReflectiveInvoker> TYPE_TO_STRONGLY_TYPED_HEADERS_CONSTRUCTOR_CACHE = new ConcurrentHashMap<Type, ReflectiveInvoker>();
    private static final ReflectiveInvoker NO_CONSTRUCTOR_REFLECTIVE_INVOKER = ReflectionUtils.createNoOpInvoker();
    private final ObjectMapper mapper;
    private MemberNameConverterImpl memberNameConverter;

    public static ObjectMapperShim createJsonMapper(ObjectMapperShim objectMapperShim, BiConsumer<ObjectMapper, ObjectMapper> biConsumer) {
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.INSTANCE.createJsonMapper(objectMapperShim.mapper);
            biConsumer.accept(objectMapper, objectMapperShim.mapper);
            return new ObjectMapperShim(objectMapper);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    public static ObjectMapperShim createXmlMapper() {
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.INSTANCE.createXmlMapper();
            return new ObjectMapperShim(objectMapper);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    public static ObjectMapperShim createSimpleMapper() {
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.INSTANCE.createSimpleMapper();
            return new ObjectMapperShim(objectMapper);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    public static ObjectMapperShim createDefaultMapper() {
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.INSTANCE.createDefaultMapper();
            return new ObjectMapperShim(objectMapper);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    public static ObjectMapperShim createPrettyPrintMapper() {
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.INSTANCE.createPrettyPrintMapper();
            return new ObjectMapperShim(objectMapper);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    public static ObjectMapperShim createHeaderMapper() {
        try {
            ObjectMapper objectMapper = ObjectMapperFactory.INSTANCE.createHeaderMapper();
            return new ObjectMapperShim(objectMapper);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    public ObjectMapperShim(ObjectMapper objectMapper) {
        this.mapper = objectMapper;
    }

    public String writeValueAsString(Object object) throws IOException {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    public byte[] writeValueAsBytes(Object object) throws IOException {
        try {
            return this.mapper.writeValueAsBytes(object);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    public void writeValue(OutputStream outputStream, Object object) throws IOException {
        try {
            this.mapper.writeValue(outputStream, object);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    public <T> T readValue(String string, Type type) throws IOException {
        try {
            JavaType javaType = this.createJavaType(type);
            return this.mapper.readValue(string, javaType);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    public <T> T readValue(byte[] byArray, Type type) throws IOException {
        try {
            JavaType javaType = this.createJavaType(type);
            return this.mapper.readValue(byArray, javaType);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    public <T> T readValue(InputStream inputStream, Type type) throws IOException {
        try {
            JavaType javaType = this.createJavaType(type);
            return this.mapper.readValue(inputStream, javaType);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    public JsonNode readTree(String string) throws IOException {
        try {
            return this.mapper.readTree(string);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    public JsonNode readTree(byte[] byArray) throws IOException {
        try {
            return this.mapper.readTree(byArray);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    private JavaType createJavaType(Type type2) {
        if (type2 == null) {
            return null;
        }
        if (type2 instanceof JavaType) {
            return (JavaType)type2;
        }
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            JavaType[] javaTypeArray = new JavaType[typeArray.length];
            for (int i2 = 0; i2 != typeArray.length; ++i2) {
                javaTypeArray[i2] = this.createJavaType(typeArray[i2]);
            }
            return ObjectMapperShim.getFromTypeCache(type2, type -> this.mapper.getTypeFactory().constructParametricType((Class)parameterizedType.getRawType(), javaTypeArray));
        }
        return ObjectMapperShim.getFromTypeCache(type2, type -> {
            JavaType javaType = this.mapper.constructType((Type)type);
            if (!(type instanceof Class)) {
                return javaType;
            }
            if (ReflectionSerializable.supportsJsonSerializable((Class)type)) {
                return javaType.withValueHandler(new JsonSerializableDeserializer((Class)type));
            }
            return javaType;
        });
    }

    public <T> T deserialize(HttpHeaders httpHeaders, Type type) throws IOException {
        ReflectiveInvoker reflectiveInvoker;
        if (type == null) {
            return null;
        }
        try {
            reflectiveInvoker = ObjectMapperShim.getFromHeadersConstructorCache(type);
            if (reflectiveInvoker != NO_CONSTRUCTOR_REFLECTIVE_INVOKER) {
                return (T)reflectiveInvoker.invokeWithArguments(httpHeaders, new Object[0]);
            }
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)exception);
            }
            LOGGER.log(LogLevel.VERBOSE, () -> "Failed to find or use invoker Constructor that accepts HttpHeaders for " + type + ".");
        }
        reflectiveInvoker = this.mapper.convertValue((Object)httpHeaders, this.createJavaType(type));
        Class<?> clazz = TypeUtil.getRawClass(type);
        Field[] fieldArray = clazz.getDeclaredFields();
        ArrayList<HeaderCollectionHandler> arrayList = new ArrayList<HeaderCollectionHandler>();
        HashSet<Character> hashSet = new HashSet<Character>();
        for (Field field : fieldArray) {
            HeaderCollection headerCollection;
            String string;
            int n2;
            Type[] typeArray;
            if (!field.isAnnotationPresent(HeaderCollection.class)) continue;
            Type object = field.getGenericType();
            if (!TypeUtil.isTypeOrSubTypeOf(field.getType(), Map.class) || (typeArray = TypeUtil.getTypeArguments(object)).length != 2 || typeArray[0] != String.class || typeArray[1] != String.class || (n2 = (string = (headerCollection = field.getAnnotation(HeaderCollection.class)).value().toLowerCase(Locale.ROOT)).length()) == 0) continue;
            arrayList.add(new HeaderCollectionHandler(string, field));
            hashSet.add(Character.valueOf(string.charAt(0)));
        }
        for (HttpHeader httpHeader : httpHeaders) {
            String string = httpHeader.getName().toLowerCase(Locale.ROOT);
            if (!hashSet.contains(Character.valueOf(string.charAt(0)))) continue;
            for (HeaderCollectionHandler headerCollectionHandler2 : arrayList) {
                if (!headerCollectionHandler2.headerStartsWithPrefix(string)) continue;
                headerCollectionHandler2.addHeader(httpHeader.getName(), httpHeader.getValue());
            }
        }
        arrayList.forEach(headerCollectionHandler -> headerCollectionHandler.injectValuesIntoDeclaringField(reflectiveInvoker, LOGGER));
        return (T)reflectiveInvoker;
    }

    public String convertMemberName(Member member) {
        if (this.memberNameConverter == null) {
            this.memberNameConverter = new MemberNameConverterImpl(this.mapper);
        }
        try {
            return this.memberNameConverter.convertMemberName(member);
        }
        catch (LinkageError linkageError) {
            throw LOGGER.logThrowableAsError(new LinkageError(JacksonVersion.getHelpInfo(), linkageError));
        }
    }

    private static JavaType getFromTypeCache(Type type, Function<Type, JavaType> function) {
        if (TYPE_TO_JAVA_TYPE_CACHE.size() >= 10000) {
            TYPE_TO_JAVA_TYPE_CACHE.clear();
        }
        return TYPE_TO_JAVA_TYPE_CACHE.computeIfAbsent(type, function);
    }

    private static ReflectiveInvoker getFromHeadersConstructorCache(Type type2) {
        if (TYPE_TO_STRONGLY_TYPED_HEADERS_CONSTRUCTOR_CACHE.size() >= 10000) {
            TYPE_TO_STRONGLY_TYPED_HEADERS_CONSTRUCTOR_CACHE.clear();
        }
        return TYPE_TO_STRONGLY_TYPED_HEADERS_CONSTRUCTOR_CACHE.computeIfAbsent(type2, type -> {
            try {
                Class<?> clazz = TypeUtil.getRawClass(type);
                return ReflectionUtils.getConstructorInvoker(clazz, clazz.getDeclaredConstructor(HttpHeaders.class));
            }
            catch (Throwable throwable) {
                if (throwable instanceof Error) {
                    throw LOGGER.logThrowableAsError((Error)throwable);
                }
                return NO_CONSTRUCTOR_REFLECTIVE_INVOKER;
            }
        });
    }
}

