/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.StringBuilderWriter;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.module.SimpleModule;

final class BinaryDataDeserializer
extends JsonDeserializer<BinaryData> {
    BinaryDataDeserializer() {
    }

    public static SimpleModule getModule() {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addDeserializer(BinaryData.class, new BinaryDataDeserializer());
        return simpleModule;
    }

    @Override
    public BinaryData deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == JsonToken.VALUE_NULL) {
            return null;
        }
        if (jsonToken.isStructStart()) {
            return BinaryData.fromString(BinaryDataDeserializer.bufferStruct(jsonParser));
        }
        return BinaryData.fromString(jsonParser.getText());
    }

    private static String bufferStruct(JsonParser jsonParser) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(128);
        StringBuilderWriter stringBuilderWriter = new StringBuilderWriter(stringBuilder);
        stringBuilder.append(jsonParser.currentToken() == JsonToken.START_OBJECT ? (char)'{' : '[');
        JsonToken jsonToken = jsonParser.currentToken();
        int n2 = 1;
        block5: while (n2 > 0) {
            JsonToken jsonToken2 = jsonParser.nextToken();
            if (!jsonToken.isStructStart() && !jsonToken2.isStructEnd() && jsonToken != JsonToken.FIELD_NAME) {
                stringBuilder.append(',');
            }
            jsonToken = jsonToken2;
            switch (jsonToken2) {
                case START_ARRAY: 
                case START_OBJECT: {
                    ++n2;
                    stringBuilder.append(jsonToken2 == JsonToken.START_OBJECT ? (char)'{' : '[');
                    continue block5;
                }
                case END_ARRAY: 
                case END_OBJECT: {
                    --n2;
                    stringBuilder.append(jsonToken2 == JsonToken.END_OBJECT ? (char)'}' : ']');
                    continue block5;
                }
                case FIELD_NAME: 
                case VALUE_STRING: {
                    stringBuilder.append("\"");
                    jsonParser.getText(stringBuilderWriter);
                    stringBuilder.append(jsonToken2 == JsonToken.FIELD_NAME ? "\":" : "\"");
                    continue block5;
                }
            }
            jsonParser.getText(stringBuilderWriter);
        }
        return stringBuilder.toString();
    }
}

