/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson.JacksonJsonReader;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.json.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.json.JsonReadFeature;

final class AzureJsonUtils {
    private static final JsonFactory FACTORY = JsonFactory.builder().build();

    static JsonReader createReader(byte[] byArray, JsonOptions jsonOptions) throws IOException {
        Objects.requireNonNull(byArray, "JSON source cannot be null when creating a JsonReader.");
        return new JacksonJsonReader(AzureJsonUtils.configureParser(FACTORY.createParser(byArray), jsonOptions), byArray, null, true, jsonOptions);
    }

    static JsonReader createReader(String string, JsonOptions jsonOptions) throws IOException {
        Objects.requireNonNull(string, "JSON source cannot be null when creating a JsonReader.");
        return new JacksonJsonReader(AzureJsonUtils.configureParser(FACTORY.createParser(string), jsonOptions), null, string, true, jsonOptions);
    }

    private static JsonParser configureParser(JsonParser jsonParser, JsonOptions jsonOptions) {
        boolean bl2 = jsonOptions == null || jsonOptions.isNonNumericNumbersSupported();
        return jsonParser.configure(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS.mappedFeature(), bl2);
    }

    static JsonReader createReader(JsonParser jsonParser) {
        return new JacksonJsonReader(jsonParser, null, null, false, null);
    }

    private AzureJsonUtils() {
    }
}

