/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.jackson;

import java.io.IOException;
import java.lang.reflect.Field;
import macromedia.jdbc.sqlserver.externals.com.azure.core.annotation.JsonFlatten;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.TypeUtil;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonProperty;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonFactory;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.BeanDescription;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationConfig;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.DeserializationContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.module.SimpleModule;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ObjectNode;

final class AdditionalPropertiesDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer {
    private static final long serialVersionUID = 700052863615540646L;
    private final JsonDeserializer<?> defaultDeserializer;
    private final ObjectMapper mapper;

    protected AdditionalPropertiesDeserializer(Class<?> clazz, JsonDeserializer<?> jsonDeserializer, ObjectMapper objectMapper) {
        super(clazz);
        this.defaultDeserializer = jsonDeserializer;
        this.mapper = objectMapper;
    }

    public static SimpleModule getModule(final ObjectMapper objectMapper) {
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.setDeserializerModifier(new BeanDeserializerModifier(){

            @Override
            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig deserializationConfig, BeanDescription beanDescription, JsonDeserializer<?> jsonDeserializer) {
                for (Class<?> clazz : TypeUtil.getAllClasses(beanDescription.getBeanClass())) {
                    Field[] fieldArray;
                    for (Field field : fieldArray = clazz.getDeclaredFields()) {
                        JsonProperty jsonProperty;
                        if (!"additionalProperties".equalsIgnoreCase(field.getName()) || (jsonProperty = field.getAnnotation(JsonProperty.class)) == null || !jsonProperty.value().isEmpty()) continue;
                        return new AdditionalPropertiesDeserializer(beanDescription.getBeanClass(), jsonDeserializer, objectMapper);
                    }
                }
                return jsonDeserializer;
            }
        });
        return simpleModule;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        ObjectNode objectNode = (ObjectNode)this.mapper.readTree(jsonParser);
        ObjectNode objectNode2 = objectNode.deepCopy();
        Class<?> clazz = this.defaultDeserializer.handledType();
        boolean bl2 = clazz.getAnnotation(JsonFlatten.class) != null;
        for (Class<?> clazz2 : TypeUtil.getAllClasses(clazz)) {
            Field[] fieldArray;
            for (Field field : fieldArray = clazz2.getDeclaredFields()) {
                String string;
                if (field.isSynthetic()) continue;
                JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
                String string2 = string = bl2 ? AdditionalPropertiesDeserializer.jsonFlattenSplit(jsonProperty.value()) : jsonProperty.value();
                if (string.isEmpty() || !objectNode2.has(string)) continue;
                objectNode2.remove(string);
            }
        }
        objectNode.set("additionalProperties", objectNode2);
        JsonParser jsonParser2 = new JsonFactory().createParser(objectNode.toString());
        jsonParser2.nextToken();
        return this.defaultDeserializer.deserialize(jsonParser2, deserializationContext);
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        ((ResolvableDeserializer)((Object)this.defaultDeserializer)).resolve(deserializationContext);
    }

    private static String jsonFlattenSplit(String string) {
        int n2 = AdditionalPropertiesDeserializer.indexOfSplit(string);
        return n2 == -1 ? string : string.substring(0, n2);
    }

    private static int indexOfSplit(String string) {
        int n2 = 0;
        while ((n2 = string.indexOf(46, n2)) != -1) {
            if (n2 - 2 < 0) {
                return n2;
            }
            if (string.charAt(n2 - 1) == '\\' && string.charAt(n2 - 2) == '\\') continue;
            return n2;
        }
        return -1;
    }
}

