/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.io.IOException;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;

public final class SemanticVersion
implements Comparable<SemanticVersion> {
    public static final String UNKNOWN_VERSION = "unknown";
    private final int major;
    private final int minor;
    private final int patch;
    private final String prerelease;
    private final String versionString;

    public static SemanticVersion getPackageVersionForClass(String string) {
        try {
            return SemanticVersion.getPackageVersion(Class.forName(string));
        }
        catch (Exception exception) {
            return SemanticVersion.createInvalid();
        }
    }

    public static SemanticVersion parse(String string) {
        int n2;
        int n3;
        Objects.requireNonNull(string, "'version' cannot be null.");
        int n4 = string.indexOf(46);
        if (n4 < 0) {
            return SemanticVersion.createInvalid(string);
        }
        int n5 = string.indexOf(46, n4 + 1);
        if (n5 < 0) {
            return SemanticVersion.createInvalid(string);
        }
        for (n3 = n5 + 1; n3 < string.length() && (n2 = string.charAt(n3)) != 46 && n2 != 45 && n2 != 43; ++n3) {
        }
        n2 = string.indexOf(43, n3);
        if (n2 < 0) {
            n2 = string.length();
        }
        try {
            int n6 = Integer.parseInt(string.substring(0, n4));
            int n7 = Integer.parseInt(string.substring(n4 + 1, n5));
            int n8 = Integer.parseInt(string.substring(n5 + 1, n3));
            String string2 = n3 == n2 ? "" : string.substring(n3 + 1, n2);
            return new SemanticVersion(n6, n7, n8, string2, string);
        }
        catch (NumberFormatException numberFormatException) {
            return SemanticVersion.createInvalid(string);
        }
    }

    private static SemanticVersion getPackageVersion(Class<?> clazz) {
        SemanticVersion semanticVersion;
        Objects.requireNonNull(clazz, "'clazz' cannot be null.");
        if (clazz.getPackage() == null) {
            return SemanticVersion.createInvalid();
        }
        String string = clazz.getPackage().getImplementationVersion();
        if (string != null) {
            return SemanticVersion.parse(string);
        }
        JarFile jarFile = new JarFile(clazz.getProtectionDomain().getCodeSource().getLocation().getFile());
        try {
            Manifest manifest = jarFile.getManifest();
            string = manifest.getMainAttributes().getValue("Implementation-Version");
            if (string == null) {
                string = manifest.getMainAttributes().getValue("Bundle-Version");
            }
            semanticVersion = SemanticVersion.parse(string);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | SecurityException exception) {
                return SemanticVersion.createInvalid();
            }
        }
        jarFile.close();
        return semanticVersion;
    }

    public static SemanticVersion createInvalid() {
        return SemanticVersion.createInvalid(UNKNOWN_VERSION);
    }

    private static SemanticVersion createInvalid(String string) {
        return new SemanticVersion(-1, -1, -1, null, string);
    }

    SemanticVersion(int n2, int n3, int n4, String string, String string2) {
        Objects.requireNonNull(string2, "'versionString' cannot be null.");
        this.major = n2;
        this.minor = n3;
        this.patch = n4;
        this.prerelease = string;
        this.versionString = string2;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public int getMajorVersion() {
        return this.major;
    }

    @Override
    public int compareTo(SemanticVersion semanticVersion) {
        if (this == semanticVersion) {
            return 0;
        }
        if (semanticVersion == null) {
            return -1;
        }
        if (this.major != semanticVersion.major) {
            return this.major > semanticVersion.major ? 1 : -1;
        }
        if (this.minor != semanticVersion.minor) {
            return this.minor > semanticVersion.minor ? 1 : -1;
        }
        if (this.patch != semanticVersion.patch) {
            return this.patch > semanticVersion.patch ? 1 : -1;
        }
        if (CoreUtils.isNullOrEmpty(this.prerelease)) {
            return CoreUtils.isNullOrEmpty(semanticVersion.prerelease) ? 0 : 1;
        }
        if (CoreUtils.isNullOrEmpty(semanticVersion.prerelease)) {
            return -1;
        }
        return this.prerelease.compareTo(semanticVersion.prerelease);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion semanticVersion = (SemanticVersion)object;
        return this.versionString.equals(semanticVersion.versionString);
    }

    public int hashCode() {
        return this.versionString.hashCode();
    }

    public String toString() {
        return this.versionString;
    }

    public boolean isValid() {
        return this.major >= 0;
    }
}

