/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.implementation;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.ProgressReporter;

public class ByteCountingWritableByteChannel
implements WritableByteChannel {
    private final WritableByteChannel channel;
    private final ProgressReporter progressReporter;
    private static final AtomicLongFieldUpdater<ByteCountingWritableByteChannel> BYTES_WRITTEN_ATOMIC_UPDATER = AtomicLongFieldUpdater.newUpdater(ByteCountingWritableByteChannel.class, "bytesWritten");
    private volatile long bytesWritten;

    public ByteCountingWritableByteChannel(WritableByteChannel writableByteChannel, ProgressReporter progressReporter) {
        this.channel = Objects.requireNonNull(writableByteChannel, "'channel' must not be null");
        this.progressReporter = progressReporter;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        int n2 = this.channel.write(byteBuffer);
        BYTES_WRITTEN_ATOMIC_UPDATER.addAndGet(this, n2);
        if (this.progressReporter != null) {
            this.progressReporter.reportProgress(n2);
        }
        return n2;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    public long getBytesWritten() {
        return BYTES_WRITTEN_ATOMIC_UPDATER.get(this);
    }
}

