/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipeline;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.rest.RequestOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.AsyncRestProxy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.RestProxyUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.SwaggerInterfaceParser;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.SwaggerMethodParser;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.rest.SyncRestProxy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Configuration;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.Context;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.serializer.SerializerAdapter;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class RestProxy
implements InvocationHandler {
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLED = "macromedia.jdbc.sqlserver.externals.com.azure.core.http.restproxy.syncproxy.enable";
    private static final boolean GLOBAL_SYNC_PROXY_ENABLED = Configuration.getGlobalConfiguration().get("AZURE_HTTP_REST_PROXY_SYNC_PROXY_ENABLED", true);
    private final SwaggerInterfaceParser interfaceParser;
    private final AsyncRestProxy asyncRestProxy;
    private final HttpPipeline httpPipeline;
    private final SyncRestProxy syncRestProxy;

    private RestProxy(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, SwaggerInterfaceParser swaggerInterfaceParser) {
        this.interfaceParser = swaggerInterfaceParser;
        this.asyncRestProxy = new AsyncRestProxy(httpPipeline, serializerAdapter, swaggerInterfaceParser);
        this.syncRestProxy = new SyncRestProxy(httpPipeline, serializerAdapter, swaggerInterfaceParser);
        this.httpPipeline = httpPipeline;
    }

    private SwaggerMethodParser getMethodParser(Method method) {
        return this.interfaceParser.getMethodParser(method);
    }

    public Mono<HttpResponse> send(HttpRequest httpRequest, Context context) {
        return this.httpPipeline.send(httpRequest, context);
    }

    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) {
        SwaggerMethodParser swaggerMethodParser = this.getMethodParser(method);
        RequestOptions requestOptions = swaggerMethodParser.setRequestOptions(objectArray);
        Context context = swaggerMethodParser.setContext(objectArray);
        if (swaggerMethodParser.isReactive() || RestProxy.isSyncDisabled(context)) {
            return this.asyncRestProxy.invoke(object, method, requestOptions, requestOptions != null ? requestOptions.getErrorOptions() : null, requestOptions != null ? requestOptions.getRequestCallback() : null, swaggerMethodParser, swaggerMethodParser.isReactive(), objectArray);
        }
        return this.syncRestProxy.invoke(object, method, requestOptions, requestOptions != null ? requestOptions.getErrorOptions() : null, requestOptions != null ? requestOptions.getRequestCallback() : null, swaggerMethodParser, false, objectArray);
    }

    private static boolean isSyncDisabled(Context context) {
        return (Boolean)context.getData(HTTP_REST_PROXY_SYNC_PROXY_ENABLED).orElse(GLOBAL_SYNC_PROXY_ENABLED) == false;
    }

    public static <A> A create(Class<A> clazz) {
        return RestProxy.create(clazz, RestProxyUtils.createDefaultPipeline(), RestProxyUtils.createDefaultSerializer());
    }

    public static <A> A create(Class<A> clazz, HttpPipeline httpPipeline) {
        return RestProxy.create(clazz, httpPipeline, RestProxyUtils.createDefaultSerializer());
    }

    public static <A> A create(Class<A> clazz, HttpPipeline httpPipeline, SerializerAdapter serializerAdapter) {
        SwaggerInterfaceParser swaggerInterfaceParser = SwaggerInterfaceParser.getInstance(clazz);
        RestProxy restProxy = new RestProxy(httpPipeline, serializerAdapter, swaggerInterfaceParser);
        return (A)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)restProxy);
    }
}

