/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.temporal.ChronoUnit;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaders;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.ExponentialBackoff;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RequestRetryCondition;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryOptions;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RetryStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.ImplUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.BinaryData;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.CoreUtils;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.ClientLogger;
import macromedia.jdbc.sqlserver.externals.com.azure.core.util.logging.LoggingEventBuilder;
import macromedia.jdbc.sqlserver.externals.reactor.core.Exceptions;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public class RetryPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(RetryPolicy.class);
    private final RetryStrategy retryStrategy;
    private final HttpHeaderName retryAfterHeader;
    private final ChronoUnit retryAfterTimeUnit;

    public RetryPolicy() {
        this(new ExponentialBackoff(), null, null);
    }

    public RetryPolicy(String string, ChronoUnit chronoUnit) {
        this(new ExponentialBackoff(), string, chronoUnit);
    }

    public RetryPolicy(RetryStrategy retryStrategy, String string, ChronoUnit chronoUnit) {
        this.retryStrategy = Objects.requireNonNull(retryStrategy, "'retryStrategy' cannot be null.");
        this.retryAfterHeader = HttpHeaderName.fromString(string);
        this.retryAfterTimeUnit = chronoUnit;
        if (!CoreUtils.isNullOrEmpty(string)) {
            Objects.requireNonNull(chronoUnit, "'retryAfterTimeUnit' cannot be null.");
        }
    }

    public RetryPolicy(RetryStrategy retryStrategy) {
        this(retryStrategy, null, null);
    }

    public RetryPolicy(RetryOptions retryOptions) {
        this(ImplUtils.getRetryStrategyFromOptions(retryOptions), null, null);
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        HttpRequest httpRequest = httpPipelineCallContext.getHttpRequest();
        BinaryData binaryData2 = httpRequest.getBodyAsBinaryData();
        if (this.retryStrategy.getMaxRetries() > 0 && binaryData2 != null && !binaryData2.isReplayable()) {
            return binaryData2.toReplayableBinaryDataAsync().flatMap(binaryData -> {
                httpPipelineCallContext.getHttpRequest().setBody((BinaryData)binaryData);
                return this.attemptAsync(httpPipelineCallContext, httpPipelineNextPolicy, httpRequest, 0, null);
            });
        }
        return this.attemptAsync(httpPipelineCallContext, httpPipelineNextPolicy, httpRequest, 0, null);
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy) {
        HttpRequest httpRequest = httpPipelineCallContext.getHttpRequest();
        BinaryData binaryData = httpRequest.getBodyAsBinaryData();
        if (this.retryStrategy.getMaxRetries() > 0 && binaryData != null && !binaryData.isReplayable()) {
            httpPipelineCallContext.getHttpRequest().setBody(httpPipelineCallContext.getHttpRequest().getBodyAsBinaryData().toReplayableBinaryData());
        }
        return this.attemptSync(httpPipelineCallContext, httpPipelineNextSyncPolicy, httpRequest, 0, null);
    }

    private Mono<HttpResponse> attemptAsync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy, HttpRequest httpRequest, int n2, List<Throwable> list) {
        httpPipelineCallContext.setData("requestRetryCount", n2 + 1);
        httpPipelineCallContext.setHttpRequest(httpRequest.copy());
        return httpPipelineNextPolicy.clone().process().flatMap(httpResponse -> {
            if (RetryPolicy.shouldRetry(this.retryStrategy, httpResponse, n2, list)) {
                Duration duration = RetryPolicy.determineDelayDuration(httpResponse, n2, this.retryStrategy, this.retryAfterHeader, this.retryAfterTimeUnit);
                RetryPolicy.logRetry(n2, duration);
                httpResponse.close();
                return this.attemptAsync(httpPipelineCallContext, httpPipelineNextPolicy, httpRequest, n2 + 1, list).delaySubscription(duration);
            }
            if (n2 >= this.retryStrategy.getMaxRetries()) {
                RetryPolicy.logRetryExhausted(n2);
            }
            return Mono.just((Object)httpResponse);
        }).onErrorResume(Exception.class, exception -> {
            if (RetryPolicy.shouldRetryException(this.retryStrategy, exception, n2, list)) {
                RetryPolicy.logRetryWithError(LOGGER.atVerbose(), n2, "Error resume.", exception);
                List list2 = list == null ? new LinkedList() : list;
                list2.add(exception);
                return this.attemptAsync(httpPipelineCallContext, httpPipelineNextPolicy, httpRequest, n2 + 1, list2).delaySubscription(this.retryStrategy.calculateRetryDelay(n2));
            }
            RetryPolicy.logRetryWithError(LOGGER.atError(), n2, "Retry attempts have been exhausted.", exception);
            if (list != null) {
                list.forEach(exception::addSuppressed);
            }
            return Mono.error((Throwable)exception);
        });
    }

    private HttpResponse attemptSync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy, HttpRequest httpRequest, int n2, List<Throwable> linkedList) {
        HttpResponse httpResponse;
        try {
            httpPipelineCallContext.setData("requestRetryCount", n2 + 1);
            httpPipelineCallContext.setHttpRequest(httpRequest.copy());
            httpResponse = httpPipelineNextSyncPolicy.clone().processSync();
        }
        catch (RuntimeException runtimeException) {
            if (RetryPolicy.shouldRetryException(this.retryStrategy, runtimeException, n2, linkedList)) {
                RetryPolicy.logRetryWithError(LOGGER.atVerbose(), n2, "Error resume.", runtimeException);
                try {
                    Thread.sleep(this.retryStrategy.calculateRetryDelay(n2).toMillis());
                }
                catch (InterruptedException interruptedException) {
                    runtimeException.addSuppressed(interruptedException);
                    throw LOGGER.logExceptionAsError(runtimeException);
                }
                LinkedList<Throwable> linkedList2 = linkedList == null ? new LinkedList<Throwable>() : linkedList;
                linkedList2.add(runtimeException);
                return this.attemptSync(httpPipelineCallContext, httpPipelineNextSyncPolicy, httpRequest, n2 + 1, linkedList2);
            }
            RetryPolicy.logRetryWithError(LOGGER.atError(), n2, "Retry attempts have been exhausted.", runtimeException);
            if (linkedList != null) {
                linkedList.forEach(runtimeException::addSuppressed);
            }
            throw LOGGER.logExceptionAsError(runtimeException);
        }
        if (RetryPolicy.shouldRetry(this.retryStrategy, httpResponse, n2, linkedList)) {
            Duration duration = RetryPolicy.determineDelayDuration(httpResponse, n2, this.retryStrategy, this.retryAfterHeader, this.retryAfterTimeUnit);
            RetryPolicy.logRetry(n2, duration);
            httpResponse.close();
            try {
                Thread.sleep(duration.toMillis());
            }
            catch (InterruptedException interruptedException) {
                throw LOGGER.logExceptionAsError(new RuntimeException(interruptedException));
            }
            return this.attemptSync(httpPipelineCallContext, httpPipelineNextSyncPolicy, httpRequest, n2 + 1, linkedList);
        }
        if (n2 >= this.retryStrategy.getMaxRetries()) {
            RetryPolicy.logRetryExhausted(n2);
        }
        return httpResponse;
    }

    private static boolean shouldRetry(RetryStrategy retryStrategy, HttpResponse httpResponse, int n2, List<Throwable> list) {
        return n2 < retryStrategy.getMaxRetries() && retryStrategy.shouldRetryCondition(new RequestRetryCondition(httpResponse, null, n2, list));
    }

    private static boolean shouldRetryException(RetryStrategy retryStrategy, Throwable throwable, int n2, List<Throwable> list) {
        Throwable throwable2;
        if (n2 >= retryStrategy.getMaxRetries()) {
            return false;
        }
        RequestRetryCondition requestRetryCondition = new RequestRetryCondition(null, throwable2, n2, list);
        for (throwable2 = Exceptions.unwrap((Throwable)throwable); throwable2 != null; throwable2 = throwable2.getCause()) {
            if (retryStrategy.shouldRetryCondition(requestRetryCondition)) {
                return true;
            }
            requestRetryCondition = new RequestRetryCondition(null, throwable2, n2, list);
        }
        return false;
    }

    private static void logRetry(int n2, Duration duration) {
        LOGGER.atVerbose().addKeyValue("tryCount", n2).addKeyValue("durationMs", duration.toMillis()).log("Retrying.");
    }

    private static void logRetryExhausted(int n2) {
        LOGGER.atInfo().addKeyValue("tryCount", n2).log("Retry attempts have been exhausted.");
    }

    private static void logRetryWithError(LoggingEventBuilder loggingEventBuilder, int n2, String string, Throwable throwable) {
        loggingEventBuilder.addKeyValue("tryCount", n2).log(string, throwable);
    }

    static Duration determineDelayDuration(HttpResponse httpResponse, int n2, RetryStrategy retryStrategy, HttpHeaderName httpHeaderName, ChronoUnit chronoUnit) {
        if (httpHeaderName == null) {
            return RetryPolicy.getWellKnownRetryDelay(httpResponse.getHeaders(), n2, retryStrategy, OffsetDateTime::now);
        }
        String string = httpResponse.getHeaderValue(httpHeaderName);
        if (CoreUtils.isNullOrEmpty(string)) {
            return retryStrategy.calculateRetryDelay(n2);
        }
        return Duration.of(Integer.parseInt(string), chronoUnit);
    }

    static Duration getWellKnownRetryDelay(HttpHeaders httpHeaders, int n2, RetryStrategy retryStrategy, Supplier<OffsetDateTime> supplier) {
        Duration duration = ImplUtils.getRetryAfterFromHeaders(httpHeaders, supplier);
        if (duration != null) {
            return duration;
        }
        return retryStrategy.calculateRetryDelay(n2);
    }
}

