/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpHeaderName;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineCallContext;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpPipelineNextSyncPolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.DefaultRedirectStrategy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.RedirectStrategy;
import macromedia.jdbc.sqlserver.externals.reactor.core.publisher.Mono;

public final class RedirectPolicy
implements HttpPipelinePolicy {
    private final RedirectStrategy redirectStrategy;

    public RedirectPolicy() {
        this(new DefaultRedirectStrategy());
    }

    public RedirectPolicy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = Objects.requireNonNull(redirectStrategy, "'redirectStrategy' cannot be null.");
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy) {
        return this.attemptRedirect(httpPipelineCallContext, httpPipelineNextPolicy, httpPipelineCallContext.getHttpRequest(), 1, new HashSet<String>());
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy) {
        return this.attemptRedirectSync(httpPipelineCallContext, httpPipelineNextSyncPolicy, httpPipelineCallContext.getHttpRequest(), 1, new HashSet<String>());
    }

    private Mono<HttpResponse> attemptRedirect(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextPolicy httpPipelineNextPolicy, HttpRequest httpRequest, int n2, Set<String> set) {
        httpPipelineCallContext.setHttpRequest(httpRequest.copy());
        return httpPipelineNextPolicy.clone().process().flatMap(httpResponse -> {
            if (this.redirectStrategy.shouldAttemptRedirect(httpPipelineCallContext, (HttpResponse)httpResponse, n2, set)) {
                HttpRequest httpRequest = this.createRedirectRequest((HttpResponse)httpResponse);
                return this.attemptRedirect(httpPipelineCallContext, httpPipelineNextPolicy, httpRequest, n2 + 1, set);
            }
            return Mono.just((Object)httpResponse);
        });
    }

    private HttpResponse attemptRedirectSync(HttpPipelineCallContext httpPipelineCallContext, HttpPipelineNextSyncPolicy httpPipelineNextSyncPolicy, HttpRequest httpRequest, int n2, Set<String> set) {
        httpPipelineCallContext.setHttpRequest(httpRequest.copy());
        HttpResponse httpResponse = httpPipelineNextSyncPolicy.clone().processSync();
        if (this.redirectStrategy.shouldAttemptRedirect(httpPipelineCallContext, httpResponse, n2, set)) {
            HttpRequest httpRequest2 = this.createRedirectRequest(httpResponse);
            return this.attemptRedirectSync(httpPipelineCallContext, httpPipelineNextSyncPolicy, httpRequest2, n2 + 1, set);
        }
        return httpResponse;
    }

    private HttpRequest createRedirectRequest(HttpResponse httpResponse) {
        httpResponse.getRequest().getHeaders().remove(HttpHeaderName.AUTHORIZATION);
        HttpRequest httpRequest = this.redirectStrategy.createRedirectRequest(httpResponse);
        httpResponse.close();
        return httpRequest;
    }
}

