/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.AfterRetryPolicyProvider;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.BeforeRetryPolicyProvider;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPipelinePolicy;
import macromedia.jdbc.sqlserver.externals.com.azure.core.http.policy.HttpPolicyProvider;
import macromedia.jdbc.sqlserver.externals.com.azure.core.implementation.http.policy.InstrumentationPolicy;

public final class HttpPolicyProviders {
    private static final String INVALID_POLICY = "HttpPipelinePolicy created with %s resulted in a null policy.";
    private static final List<BeforeRetryPolicyProvider> BEFORE_PROVIDER = new ArrayList<BeforeRetryPolicyProvider>();
    private static final List<AfterRetryPolicyProvider> AFTER_PROVIDER = new ArrayList<AfterRetryPolicyProvider>();

    private HttpPolicyProviders() {
    }

    public static void addBeforeRetryPolicies(List<HttpPipelinePolicy> list) {
        HttpPolicyProviders.addPolices(list, BEFORE_PROVIDER);
    }

    public static void addAfterRetryPolicies(List<HttpPipelinePolicy> list) {
        list.add(new InstrumentationPolicy());
        HttpPolicyProviders.addPolices(list, AFTER_PROVIDER);
    }

    private static void addPolices(List<HttpPipelinePolicy> list, List<? extends HttpPolicyProvider> list2) {
        for (HttpPolicyProvider httpPolicyProvider : list2) {
            HttpPipelinePolicy httpPipelinePolicy = httpPolicyProvider.create();
            if (httpPipelinePolicy == null) {
                throw new NullPointerException(String.format(INVALID_POLICY, httpPolicyProvider.getClass()));
            }
            list.add(httpPipelinePolicy);
        }
    }

    static {
        ServiceLoader.load(BeforeRetryPolicyProvider.class, HttpPolicyProviders.class.getClassLoader()).forEach(BEFORE_PROVIDER::add);
        ServiceLoader.load(AfterRetryPolicyProvider.class, HttpPolicyProviders.class.getClassLoader()).forEach(AFTER_PROVIDER::add);
    }
}

